/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverBehavior
extends AbstractBehavior {
    public static final String HOVER_FEEDBACK_PART_FACTORY = "HOVER_FEEDBACK_PART_FACTORY";
    public static final String HOVER_HANDLE_PART_FACTORY = "HOVER_HANDLE_PART_FACTORY";
    private ChangeListener<IVisualPart<? extends Node>> hoverObserver = new ChangeListener<IVisualPart<? extends Node>>(){

        public void changed(ObservableValue<? extends IVisualPart<? extends Node>> observable, IVisualPart<? extends Node> oldValue, IVisualPart<? extends Node> newValue) {
            HoverBehavior.this.onHoverChange(oldValue, newValue);
        }
    };
    private final Map<IVisualPart<? extends Node>, Effect> effects = new HashMap<IVisualPart<? extends Node>, Effect>();

    @Override
    protected void doActivate() {
        HoverModel hoverModel = this.getHoverModel();
        IVisualPart<? extends Node> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(null, hover);
        }
        hoverModel.hoverProperty().addListener(this.hoverObserver);
    }

    @Override
    protected void doDeactivate() {
        HoverModel hoverModel = this.getHoverModel();
        hoverModel.hoverProperty().removeListener(this.hoverObserver);
        IVisualPart<? extends Node> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(hover, null);
        }
    }

    @Override
    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        return this.getFeedbackPartFactory(viewer, HOVER_FEEDBACK_PART_FACTORY);
    }

    public Effect getHandleHoverFeedbackEffect(Map<Object, Object> contextMap) {
        DropShadow effect = new DropShadow();
        effect.setRadius(5.0);
        return effect;
    }

    @Override
    protected IHandlePartFactory getHandlePartFactory(IViewer viewer) {
        return this.getHandlePartFactory(viewer, HOVER_HANDLE_PART_FACTORY);
    }

    protected HoverModel getHoverModel() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        HoverModel hoverModel = (HoverModel)((Object)viewer.getAdapter(HoverModel.class));
        return hoverModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onHoverChange(IVisualPart<? extends Node> oldHovered, IVisualPart<? extends Node> newHovered) {
        if (oldHovered != null) {
            if (oldHovered instanceof IHandlePart) {
                if (!this.effects.containsKey(oldHovered)) throw new IllegalStateException("Cannot unhover/restore effect <" + oldHovered + ">.");
                oldHovered.getVisual().setEffect(this.effects.remove(oldHovered));
            } else {
                this.removeHandles(oldHovered);
                this.removeFeedback(oldHovered);
            }
        }
        if (newHovered == null) return;
        if (newHovered instanceof IHandlePart) {
            this.effects.put(newHovered, newHovered.getVisual().getEffect());
            newHovered.getVisual().setEffect(this.getHandleHoverFeedbackEffect(Collections.emptyMap()));
            return;
        } else {
            this.addFeedback(newHovered);
            this.addHandles(newHovered);
        }
    }
}

