/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.filters;

import com.google.common.base.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.jdt.annotation.Nullable;

public class QueueSizeLimitFilter
implements Predicate<IStatus> {
    private ILogEventsQueue queue;
    private int max;
    private boolean reviewIsInProgress;

    @Inject
    public QueueSizeLimitFilter(ILogEventsQueue queue, int max) {
        this.queue = queue;
        this.max = max;
    }

    public boolean apply(@Nullable IStatus input) {
        boolean sizeLimitIsReached;
        EList<ILogEventGroup> groups = this.queue.getGroups();
        boolean bl = sizeLimitIsReached = groups.size() >= this.max;
        if (sizeLimitIsReached) {
            if (this.reviewIsInProgress) {
                return false;
            }
            groups.remove(0);
            return true;
        }
        return true;
    }

    @Inject
    protected void setReviewInProgress(@Named(value="org.eclipse.epp.logging.aeri.ide.di.review-in-progress") boolean newState) {
        this.reviewIsInProgress = newState;
    }
}

