/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.core.runtime.Platform;

public final class Constants implements IModelPackage.Literals {

    public static final String AERI_NAMESPACE = "org.eclipse.epp.logging.aeri";
    public static final String BUNDLE_ID = "org.eclipse.epp.logging.aeri.core";
    public static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption(BUNDLE_ID + "/debug"));

    /**
     * Specifying '-Dorg.eclipse.epp.logging.aeri.skipReports=true' as vmarg in eclipse launch configurations skips automated error
     * reporting startup.
     */
    public static final String SYSPROP_DISABLE_AERI = AERI_NAMESPACE + ".skipReports";
    public static final String SYSPROP_DISABLE_AERI_V1 = "org.eclipse.epp.logging.aeri.ui.skipReports";

    // It seems that normal tycho builds use build.id be default
    // to make aeri work in those setups you need to add the following to you pom:
    // <configurations>
    // < property name="eclipse.buildId" value="${unqualifiedVersion}.${buildQualifier}" />
    // </configurations>

    public static final String SYSPROP_BUILD_ID = "build.id";
    public static final String SYSPROP_ECLIPSE_BUILD_ID = "eclipse.buildId";
    public static final String SYSPROP_ECLIPSE_PRODUCT = "eclipse.product";

    // values for anonymization
    public static final String HIDDEN = "HIDDEN";
    public static final String MISSING = "MISSING";
    public static final String SOURCE_BEGIN_MESSAGE = "----------------------------------- SOURCE BEGIN -------------------------------------";
    public static final String SOURCE_FILE_REMOVED = "source file contents removed";

    private Constants() {
    }
}
