/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.core.ext;

import java.io.InputStream;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.EMFDiffMergeCoreConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.core.Messages;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractURIConvertingScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.connector.core.ext.LocalHistoryURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.ui.IEditorInput;

public abstract class AbstractRevisionScopeDefinitionFactory
extends AbstractURIConvertingScopeDefinitionFactory {
    protected URI convertToURI(Object entrypoint_p) {
        IFileRevision revision;
        URI result = null;
        if (entrypoint_p instanceof ITypedElement && (revision = this.getRevision((ITypedElement)entrypoint_p)) != null) {
            try {
                result = this.getURIForRevision(revision);
            }
            catch (CoreException e) {
                EMFDiffMergeCoreConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeCoreConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
        if (result == null) {
            result = super.convertToURI(entrypoint_p);
        }
        return result;
    }

    public String getLabel() {
        return Messages.AbstractRevisionScopeDefinitionFactory_Label;
    }

    protected String getLabelFor(Object entrypoint_p) {
        ITypedElement typedElement;
        IFileRevision revision;
        String result = null;
        if (entrypoint_p instanceof ITypedElement && (revision = this.getRevision(typedElement = (ITypedElement)entrypoint_p)) != null) {
            result = this.getLabelForRevision(revision, typedElement);
        }
        if (result == null) {
            result = super.getLabelFor(entrypoint_p);
        }
        return result;
    }

    protected String getLabelForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        return revision_p.getContentIdentifier();
    }

    protected IFileRevision getRevision(ITypedElement entrypoint_p) {
        IEditorInput input;
        IAdaptable adaptable;
        ISharedDocumentAdapter adapter;
        IFileRevision result = null;
        if (entrypoint_p instanceof IAdaptable && (adapter = (ISharedDocumentAdapter)(adaptable = (IAdaptable)entrypoint_p).getAdapter(ISharedDocumentAdapter.class)) != null && (input = adapter.getDocumentKey((Object)entrypoint_p)) != null) {
            result = (IFileRevision)input.getAdapter(IFileRevision.class);
        }
        return result;
    }

    protected IStorage getStorage(IFileRevision revision_p) throws CoreException {
        return revision_p.getStorage((IProgressMonitor)new NullProgressMonitor());
    }

    protected InputStream getStream(Object entrypoint_p) throws CoreException {
        IStorage storage;
        ITypedElement typedElement;
        IFileRevision revision;
        InputStream result = null;
        if (entrypoint_p instanceof ITypedElement && (revision = this.getRevision(typedElement = (ITypedElement)entrypoint_p)) != null && (storage = this.getStorage(revision)) != null) {
            result = storage.getContents();
        }
        if (result == null) {
            result = super.getStream(entrypoint_p);
        }
        return result;
    }

    protected URIConverter getURIConverter(Object entrypoint_p) {
        IFileRevision revision;
        URIConverter result = null;
        if (entrypoint_p instanceof ITypedElement && (revision = this.getRevision((ITypedElement)entrypoint_p)) != null) {
            try {
                result = this.getURIConverterForRevision(revision);
            }
            catch (CoreException e) {
                EMFDiffMergeCoreConnectorPlugin.getDefault().logError((Exception)((Object)e));
            }
        }
        return result;
    }

    protected URIConverter getURIConverterForRevision(IFileRevision revision_p) throws CoreException {
        ExtensibleURIConverterImpl result = null;
        URI uri = this.getURIForRevision(revision_p);
        if (uri != null) {
            String fullPath = uri.trimSegments(1).toString();
            long timestamp = revision_p.getTimestamp();
            result = timestamp != -1L ? new LocalHistoryURIConverter(timestamp, fullPath) : new ExtensibleURIConverterImpl();
        }
        return result;
    }

    protected URI getURIForRevision(IFileRevision revision_p) throws CoreException {
        URI result = null;
        IStorage storage = this.getStorage(revision_p);
        if (storage instanceof IFile) {
            result = this.toPlatformURI((IFile)storage);
        } else if (storage instanceof IFileState) {
            IPath fullPath = storage.getFullPath();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
            if (res.exists() && res instanceof IFile) {
                result = this.toPlatformURI((IFile)res);
            }
        } else if (storage != null) {
            result = this.toFileURI(storage.getFullPath().toString());
        }
        return result;
    }

    protected IResourceVariant getVariant(IFileRevision revision_p) {
        IResourceVariant result = null;
        if (revision_p instanceof IAdaptable) {
            result = (IResourceVariant)((IAdaptable)revision_p).getAdapter(IResourceVariant.class);
        }
        return result;
    }

    public boolean isApplicableTo(Object entrypoint_p) {
        ITypedElement typedElement;
        IFileRevision revision;
        boolean result = false;
        if (entrypoint_p instanceof ITypedElement && (revision = this.getRevision(typedElement = (ITypedElement)entrypoint_p)) != null) {
            result = this.isApplicableToRevision(revision, typedElement);
        }
        return result;
    }

    protected abstract boolean isApplicableToRevision(IFileRevision var1, ITypedElement var2);
}

