/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.accessorfactory;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.accessorfactory.PapyrusAccessorWrapper;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.context.PapyrusContextUtil;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.ITypedElement;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl.AbstractAccessorFactory;

public class PapyrusAccessorFactoryWrapper
extends AbstractAccessorFactory {
    private static final Set<String> OVERRIDE_TYPES = Sets.newHashSet((Object[])new String[]{"org.eclipse.emf.compare.rcp.ui.eTreeDiff", "org.eclipse.emf.compare.rcp.ui.eMatch", "org.eclipse.emf.compare.rcp.ui.eResourceDiff", "NODE_TYPE__EMF_EOBJECT", "NODE_TYPE__EMF_RESOURCE", "NODE_TYPE__EMF_RESOURCESET", "NODE_TYPE__EMF_COMPARISON"});

    public boolean isFactoryFor(Object target) {
        return true;
    }

    public ITypedElement createLeft(AdapterFactory adapterFactory, Object target) {
        IAccessorFactory highestRankingFactory = this.getHighestRankingFactory(target);
        if (highestRankingFactory != null) {
            ITypedElement left = highestRankingFactory.createLeft(adapterFactory, target);
            return this.wrapIfNecessary(left);
        }
        return null;
    }

    public ITypedElement createRight(AdapterFactory adapterFactory, Object target) {
        IAccessorFactory highestRankingFactory = this.getHighestRankingFactory(target);
        if (highestRankingFactory != null) {
            ITypedElement right = highestRankingFactory.createRight(adapterFactory, target);
            return this.wrapIfNecessary(right);
        }
        return null;
    }

    public ITypedElement createAncestor(AdapterFactory adapterFactory, Object target) {
        IAccessorFactory highestRankingFactory = this.getHighestRankingFactory(target);
        if (highestRankingFactory != null) {
            ITypedElement ancestor = highestRankingFactory.createAncestor(adapterFactory, target);
            return this.wrapIfNecessary(ancestor);
        }
        return null;
    }

    private ITypedElement wrapIfNecessary(ITypedElement element) {
        ICompareAccessor accessor;
        if (element instanceof ICompareAccessor && PapyrusContextUtil.isPapyrusContext((accessor = (ICompareAccessor)element).getComparison()) && this.isOverrideType(element.getType())) {
            return new PapyrusAccessorWrapper(accessor);
        }
        return element;
    }

    private boolean isOverrideType(String type) {
        return OVERRIDE_TYPES.contains(type);
    }

    private IAccessorFactory getHighestRankingFactory(Object target) {
        IAccessorFactory.Registry factoryRegistry = EMFCompareRCPUIPlugin.getDefault().getAccessorFactoryRegistry();
        Iterator factories = factoryRegistry.getFactories(target).iterator();
        IAccessorFactory ret = null;
        while (factories.hasNext()) {
            IAccessorFactory factory = (IAccessorFactory)factories.next();
            if (factory.getRanking() >= this.getRanking() || ret != null && factory.getRanking() <= ret.getRanking()) continue;
            ret = factory;
        }
        return ret;
    }
}

