/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VMenuEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private StructuredViewer viewer;
    private final List<Action> actions = new ArrayList<Action>();
    private final EStructuralFeature feature;
    @Inject
    IEclipseContext eclipseContext;
    public static final String VIEW_MENU_TAG = "ViewMenu";

    protected VMenuEditor(EStructuralFeature feature) {
        this.feature = feature;
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.VMenuEditor_AddMenuContribution, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.MENU);
            }
        });
        this.actions.add(new Action(this.Messages.VMenuEditor_AddPopupMenuContribution, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.POPUP_MENU);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_Label_ViewMenu, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                VMenuEditor.this.handleAddViewMenu();
            }
        });
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.VMenuEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.VMenuEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.viewer.setInput((Object)o.getList());
        this.getMaster().setValue(o.getOriginalParent());
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        E4PickList pickList = new E4PickList(parent, 0, null, this.Messages, this, this.feature){

            @Override
            protected void addPressed() {
                Types t = (Types)((Object)((IStructuredSelection)this.getSelection()).getFirstElement());
                if (t == Types.MENU) {
                    VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.MENU);
                } else if (t == Types.POPUP_MENU) {
                    VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.POPUP_MENU);
                } else {
                    VMenuEditor.this.handleAddViewMenu();
                }
            }

            @Override
            protected List<?> getContainerChildren(Object container) {
                if (container instanceof MPartDescriptor) {
                    return ((MPartDescriptor)container).getMenus();
                }
                if (container instanceof MPart) {
                    return ((MPart)container).getMenus();
                }
                return null;
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.viewer = pickList.getList();
        pickList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        pickList.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == Types.MENU) {
                    return ((VMenuEditor)VMenuEditor.this).Messages.MenuEditor_Label;
                }
                if (element == Types.POPUP_MENU) {
                    return ((VMenuEditor)VMenuEditor.this).Messages.PopupMenuEditor_TreeLabel;
                }
                return ((VMenuEditor)VMenuEditor.this).Messages.MenuEditor_Label_ViewMenu;
            }
        });
        pickList.setInput(Types.values());
        pickList.setSelection((ISelection)new StructuredSelection((Object)Types.MENU));
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }

    protected void handleAdd(EClass eClass) {
        EObject handler = EcoreUtil.create((EClass)eClass);
        this.setElementId(handler);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)this.feature, (Object)handler);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(handler);
        }
    }

    protected void handleAddViewMenu() {
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.getTags().add(VIEW_MENU_TAG);
        this.setElementId(menu);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)this.feature, (Object)menu);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(menu);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    static enum Types {
        MENU,
        POPUP_MENU,
        VIEW_MENU;

    }
}

