/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class VirtualSourceViewer
extends SourceViewer {
    private SelectionListener fScrollSelectionListener;

    public VirtualSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this(parent, ruler, null, false, styles);
    }

    public VirtualSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.initScrollBarListener();
        this.initControlListener();
    }

    public VirtualDocument getVirtualDocument() {
        return (VirtualDocument)this.getDocument();
    }

    private void initControlListener() {
        this.getTextWidget().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                VirtualSourceViewer.this.handleControlResized();
            }
        });
    }

    private void initScrollBarListener() {
        ScrollBar scroll = this.getTextWidget().getVerticalBar();
        this.fScrollSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VirtualSourceViewer.this.handleScrollBarSelection(e);
            }
        };
        scroll.addSelectionListener(this.fScrollSelectionListener);
    }

    public int getNumberOfVisibleLines() {
        Rectangle clArea;
        StyledText widget = this.getTextWidget();
        if (widget != null && !(clArea = widget.getClientArea()).isEmpty()) {
            return clArea.height / widget.getLineHeight() + 1;
        }
        return 0;
    }

    protected void handleScrollBarSelection(SelectionEvent e) {
        int offset = this.getVirtualDocument().getCurrentOffset();
        int lines = this.getNumberOfVisibleLines();
        if (e.detail == 0x1000001) {
            --offset;
        } else if (e.detail == 0x1000002) {
            ++offset;
        } else if (e.detail == 0x1000005) {
            offset -= lines;
        } else if (e.detail == 0x1000006) {
            offset += lines;
        } else if (e.detail != 0x1000007) {
            int cfr_ignored_0 = e.detail;
        }
        this.getVirtualDocument().updateContent(lines, offset, false);
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean revealInput) {
        VirtualDocument document = this.getVirtualDocument();
        document.updateContent(this.getNumberOfVisibleLines(), this.getVirtualDocument().getCurrentOffset(), revealInput);
    }

    protected void handleControlResized() {
        this.getVirtualDocument().updateContent(this.getNumberOfVisibleLines(), this.getVirtualDocument().getCurrentOffset(), false);
    }

    protected void handleDispose() {
        this.getVirtualDocument().dispose();
        super.handleDispose();
    }
}

