/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class ThrowValidator
extends CActivityValidator {
    String fFaultName;
    INode fFaultVariable;
    protected QName fFaultQName;

    @Override
    protected void start() {
        super.start();
        this.fFaultVariable = this.mModelQuery.lookup(this.mNode, 1, this.mNode.getAttribute(AT_FAULT_VARIABLE));
    }

    public void rule_CheckFaultName_10() {
        this.fFaultName = this.mNode.getAttribute(AT_FAULT_NAME);
        if (ThrowValidator.isEmpty(this.fFaultName)) {
            return;
        }
        this.fFaultQName = this.mModelQuery.createQName(this.mNode, this.fFaultName);
    }

    @ARule(sa=0, desc="Check if the fault is valid", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC_THROW__NO_SUCH_VARIABLE,BPELC_REF_NODE_PROBLEMS", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckFaultVariable_12() {
        if (this.fFaultVariable == null) {
            return;
        }
        String varName = this.mNode.getAttribute(AT_FAULT_VARIABLE);
        if (this.isUndefined(this.fFaultVariable)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_THROW__NO_SUCH_VARIABLE", varName);
            return;
        }
        if (this.fFaultVariable.nodeValidator().hasProblems()) {
            IProblem problem = this.createWarning();
            problem.fill("BPELC_REF_NODE_PROBLEMS", this.toString(this.mNode.nodeName()), ND_VARIABLE, AT_FAULT_VARIABLE, 1);
        }
    }

    public void rule_CheckVariableType_14() {
    }
}

