/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.olap;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.ITabularCubeModel;

public class TabularCubeHandle
extends CubeHandle
implements ITabularCubeModel {
    public TabularCubeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DataSetHandle getDataSet() {
        return (DataSetHandle)this.getElementProperty("dataSet");
    }

    public void setDataSet(DataSetHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("dataSet", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("dataSet", valueToSet);
        }
    }

    public DimensionConditionHandle addDimensionCondition(DimensionCondition condition) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle("dimensionConditions");
        return (DimensionConditionHandle)propertyHandle.addItem(condition);
    }

    public DimensionConditionHandle addDimensionCondition(DimensionCondition condition, int posn) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle("dimensionConditions");
        return (DimensionConditionHandle)propertyHandle.insertItem(condition, posn);
    }

    public Iterator joinConditionsIterator() {
        PropertyHandle propertyHandle = this.getPropertyHandle("dimensionConditions");
        return propertyHandle.iterator();
    }

    public void removeDimensionCondition(DimensionCondition condition) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle("dimensionConditions");
        propertyHandle.removeItem(condition);
    }

    public void removeDimensionCondition(DimensionConditionHandle conditionHandle) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle("dimensionConditions");
        IStructure struct = conditionHandle == null ? null : conditionHandle.getStructure();
        propertyHandle.removeItem(struct);
    }

    public DimensionConditionHandle findDimensionCondition(String hierarchyName) {
        Iterator iter = this.getPropertyHandle("dimensionConditions").iterator();
        while (iter.hasNext()) {
            DimensionConditionHandle condition = (DimensionConditionHandle)iter.next();
            String tempHierarchy = condition.getHierarchyName();
            if ((tempHierarchy != null || hierarchyName != null) && (tempHierarchy == null || !tempHierarchy.equals(hierarchyName))) continue;
            return condition;
        }
        return null;
    }

    public DimensionConditionHandle findDimensionCondition(HierarchyHandle hierarchy) {
        String hierarchyName = hierarchy == null ? null : hierarchy.getQualifiedName();
        return this.findDimensionCondition(hierarchyName);
    }

    public boolean autoPrimaryKey() {
        return this.getBooleanProperty("autoKey");
    }

    public void setAutoPrimaryKey(boolean autoKey) throws SemanticException {
        this.setBooleanProperty("autoKey", autoKey);
    }
}

