/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import net.sourceforge.nattable.persistence.IPersistable;
import net.sourceforge.nattable.sort.ISortModel;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import net.sourceforge.nattable.sort.SortHeaderLayer;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortStatePersistor<T>
implements IPersistable {
    public static final String PERSISTENCE_KEY_SORTING_STATE = ".SortHeaderLayer.sortingState";
    private final SortHeaderLayer<T> sortHeaderLayer;
    private final ISortModel sortModel;

    public SortStatePersistor(SortHeaderLayer<T> sortHeaderLayer) {
        this.sortHeaderLayer = sortHeaderLayer;
        this.sortModel = sortHeaderLayer.getSortModel();
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        int columnCount = this.sortHeaderLayer.getColumnCount();
        StringBuffer buffer = new StringBuffer();
        int columnPosition = 0;
        while (columnPosition < columnCount) {
            int columnIndex = this.sortHeaderLayer.getColumnIndexByPosition(columnPosition);
            boolean isColumnSorted = this.sortModel.isColumnIndexSorted(columnIndex);
            if (isColumnSorted) {
                SortDirectionEnum sortDirection = this.sortModel.getSortDirection(columnIndex);
                int sortOrder = this.sortModel.getSortOrder(columnIndex);
                buffer.append(columnIndex);
                buffer.append(":");
                buffer.append(sortDirection.toString());
                buffer.append(":");
                buffer.append(sortOrder);
                buffer.append("|");
            }
            ++columnPosition;
        }
        if (StringUtils.isNotEmpty((String)buffer.toString())) {
            properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_SORTING_STATE, buffer.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        Object savedValue = properties.get(String.valueOf(prefix) + PERSISTENCE_KEY_SORTING_STATE);
        if (savedValue == null) {
            return;
        }
        try {
            String savedState = savedValue.toString();
            String[] sortedColumns = savedState.split("\\|");
            ArrayList<SortState> stateInfo = new ArrayList<SortState>();
            String[] stringArray = sortedColumns;
            int n = sortedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                stateInfo.add(this.getSortStateFromString(token));
                ++n2;
            }
            Collections.sort(stateInfo, new SortStateComparator());
            for (SortState state : stateInfo) {
                this.sortModel.sort(state.columnIndex, state.sortDirection, true);
            }
        }
        catch (Exception ex) {
            this.sortModel.clear();
            System.err.println("Error while restoring sorting state. Skipping");
            ex.printStackTrace(System.err);
        }
    }

    protected SortState getSortStateFromString(String token) {
        String[] split = token.split(":");
        int columnIndex = Integer.parseInt(split[0]);
        SortDirectionEnum sortDirection = SortDirectionEnum.valueOf(split[1]);
        int sortOrder = Integer.parseInt(split[2]);
        return new SortState(columnIndex, sortDirection, sortOrder);
    }

    protected class SortState {
        public int columnIndex;
        public SortDirectionEnum sortDirection;
        public int sortOrder;

        public SortState(int columnIndex, SortDirectionEnum sortDirection, int sortOrder) {
            this.columnIndex = columnIndex;
            this.sortDirection = sortDirection;
            this.sortOrder = sortOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortStateComparator
    implements Comparator<SortState> {
        private SortStateComparator() {
        }

        @Override
        public int compare(SortState state1, SortState state2) {
            return Integer.valueOf(state1.sortOrder).compareTo(state2.sortOrder);
        }
    }
}

