/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.resize.command;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.nattable.command.AbstractMultiColumnCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

public class MultiColumnResizeCommand
extends AbstractMultiColumnCommand {
    private int commonColumnWidth = -1;
    protected Map<ColumnPositionCoordinate, Integer> colPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>();

    public MultiColumnResizeCommand(ILayer layer, int[] columnPositions, int commonColumnWidth) {
        super(layer, columnPositions);
        this.commonColumnWidth = commonColumnWidth;
    }

    public MultiColumnResizeCommand(ILayer layer, int[] columnPositions, int[] columnWidths) {
        super(layer, columnPositions);
        int i = 0;
        while (i < columnPositions.length) {
            this.colPositionToWidth.put(new ColumnPositionCoordinate(layer, columnPositions[i]), columnWidths[i]);
            ++i;
        }
    }

    protected MultiColumnResizeCommand(MultiColumnResizeCommand command) {
        super(command);
        this.commonColumnWidth = command.commonColumnWidth;
        this.colPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>(command.colPositionToWidth);
    }

    public int getCommonColumnWidth() {
        return this.commonColumnWidth;
    }

    public int getColumnWidth(int columnPosition) {
        for (ColumnPositionCoordinate columnPositionCoordinate : this.colPositionToWidth.keySet()) {
            if (columnPositionCoordinate.getColumnPosition() != columnPosition) continue;
            return this.colPositionToWidth.get(columnPositionCoordinate);
        }
        return this.commonColumnWidth;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        HashMap<ColumnPositionCoordinate, Integer> newColPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>();
        for (ColumnPositionCoordinate columnPositionCoordinate : this.colPositionToWidth.keySet()) {
            ColumnPositionCoordinate convertedColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(columnPositionCoordinate, targetLayer);
            if (convertedColumnPositionCoordinate == null) continue;
            newColPositionToWidth.put(convertedColumnPositionCoordinate, this.colPositionToWidth.get(columnPositionCoordinate));
        }
        this.colPositionToWidth = newColPositionToWidth;
        return super.convertToTargetLayer(targetLayer);
    }

    public MultiColumnResizeCommand cloneCommand() {
        return new MultiColumnResizeCommand(this);
    }
}

