/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.painter;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.CellPainterWrapper;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.painter.cell.ImagePainter;
import net.sourceforge.nattable.painter.cell.TextPainter;
import net.sourceforge.nattable.painter.cell.decorator.CellPainterDecorator;
import net.sourceforge.nattable.ui.util.CellEdgeEnum;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ColumnGroupHeaderTextPainter
extends CellPainterWrapper {
    private final ColumnGroupModel columnGroupModel;

    public ColumnGroupHeaderTextPainter(ColumnGroupModel columnGroupModel) {
        this.columnGroupModel = columnGroupModel;
        this.setWrappedPainter(new CellPainterDecorator(new TextPainter(), CellEdgeEnum.RIGHT, new ExpandCollapseImagePainter()));
    }

    public ColumnGroupHeaderTextPainter(ColumnGroupModel columnGroupModel, ICellPainter interiorPainter) {
        this.columnGroupModel = columnGroupModel;
        this.setWrappedPainter(new CellPainterDecorator(interiorPainter, CellEdgeEnum.RIGHT, new ExpandCollapseImagePainter()));
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return 0;
    }

    public class ExpandCollapseImagePainter
    extends ImagePainter {
        final Image rightImg;
        final Image leftImg;

        public ExpandCollapseImagePainter() {
            super(null, false);
            this.rightImg = GUIHelper.getImage("right");
            this.leftImg = GUIHelper.getImage("left");
        }

        protected Image getImage(LayerCell cell, IConfigRegistry configRegistry) {
            String cellValue = cell.getDataValue().toString();
            if (ColumnGroupHeaderTextPainter.this.columnGroupModel.isAGroup(cellValue)) {
                return ColumnGroupHeaderTextPainter.this.columnGroupModel.isCollapsed(cellValue) ? this.rightImg : this.leftImg;
            }
            return null;
        }
    }
}

