/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group;

import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.group.IColumnGroupModelListener;
import net.sourceforge.nattable.group.command.ColumnGroupExpandCollapseCommandHandler;
import net.sourceforge.nattable.hideshow.AbstractColumnHideShowLayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupExpandCollapseLayer
extends AbstractColumnHideShowLayer
implements IColumnGroupModelListener {
    private final ColumnGroupModel model;

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        super(underlyingLayer);
        this.model = model;
        model.registerColumnGroupModelListner(this);
        this.registerCommandHandler(new ColumnGroupExpandCollapseCommandHandler(this));
    }

    public ColumnGroupModel getModel() {
        return this.model;
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        return ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, this, underlyingLayer) || this.model.isCollapsed(columnIndex) && !ColumnGroupUtils.isFirstVisibleColumnIndexInGroup(columnIndex, this, underlyingLayer, this.model);
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        HashSet<Integer> hiddenColumnIndexes = new HashSet<Integer>();
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingColumnCount = underlyingLayer.getColumnCount();
        int i = 0;
        while (i < underlyingColumnCount) {
            int colIndex = underlyingLayer.getColumnIndexByPosition(i);
            if (this.model.isCollapsed(colIndex) && !ColumnGroupUtils.isFirstVisibleColumnIndexInGroup(colIndex, this, underlyingLayer, this.model)) {
                hiddenColumnIndexes.add(colIndex);
            }
            ++i;
        }
        return hiddenColumnIndexes;
    }

    @Override
    public void columnGroupModelChanged() {
        this.invalidateCache();
    }
}

