/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetterAccessor
extends ExpressionAccessor {
    private final Method m_setter;
    private final String m_setterSignature;
    private Method m_getter;
    private final IAccessibleExpressionAccessor m_accessibleAccessor;
    private final PropertyTooltipProvider m_tooltipProvider;
    private final IExposableExpressionAccessor m_exposableAccessor = new IExposableExpressionAccessor(){

        @Override
        public Class<?> getValueClass(JavaInfo javaInfo) {
            return SetterAccessor.this.m_setter.getParameterTypes()[0];
        }

        @Override
        public String getGetterCode(JavaInfo javaInfo) throws Exception {
            return String.valueOf(SetterAccessor.this.m_getter.getName()) + "()";
        }

        @Override
        public String getSetterCode(JavaInfo javaInfo, String source) throws Exception {
            return String.valueOf(SetterAccessor.this.m_setter.getName()) + "(" + source + ")";
        }
    };

    public SetterAccessor(Method setter, Method getter) throws Exception {
        this.m_setter = setter;
        this.m_setterSignature = ReflectionUtils.getMethodSignature((Method)this.m_setter);
        this.m_accessibleAccessor = AccessorUtils.IAccessibleExpressionAccessor_forMethod(this.m_setter);
        this.m_tooltipProvider = AccessorUtils.PropertyTooltipProvider_forMethod(this.m_setter);
        this.m_getter = getter;
    }

    public Method getSetter() {
        return this.m_setter;
    }

    public Method getGetter() {
        return this.m_getter;
    }

    public void setGetter(Method getter) {
        this.m_getter = getter;
    }

    @Override
    public void visit(JavaInfo javaInfo, int state) throws Exception {
        super.visit(javaInfo, state);
        if (this.isTimeToGetDefaultValue(javaInfo, state)) {
            javaInfo.putArbitraryValue(this, this.askDefaultValue(javaInfo));
        }
    }

    private boolean isTimeToGetDefaultValue(JavaInfo javaInfo, int state) {
        return state == 1;
    }

    private Object askDefaultValue(final JavaInfo javaInfo) throws Exception {
        if (this.m_getter != null && this.isDefaultEnabled(javaInfo)) {
            return ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Object>(){

                public Object runObject() throws Exception {
                    return SetterAccessor.this.m_getter.invoke(javaInfo.getObject(), new Object[0]);
                }
            }, (Object)Property.UNKNOWN_VALUE);
        }
        return Property.UNKNOWN_VALUE;
    }

    private boolean isDefaultEnabled(JavaInfo javaInfo) {
        if (javaInfo.getCreationSupport() instanceof ThisCreationSupport && JavaInfoUtils.hasTrueParameter(javaInfo, "noDefaultValuesForThis")) {
            return false;
        }
        return this.m_propertyDescription == null || !this.m_propertyDescription.hasTrueTag("noDefaultValue");
    }

    @Override
    public Expression getExpression(JavaInfo javaInfo) throws Exception {
        MethodInvocation invocation = this.getMethodInvocation(javaInfo);
        return this.getExpression(invocation);
    }

    @Override
    public boolean setExpression(final JavaInfo javaInfo, final String source) throws Exception {
        final MethodInvocation invocation = this.getMethodInvocation(javaInfo);
        if (invocation != null) {
            final AstEditor editor = javaInfo.getEditor();
            if (source == null) {
                ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        editor.removeEnclosingStatement((ASTNode)invocation);
                    }
                });
            } else {
                final Expression oldExpression = this.getExpression(invocation);
                if (!editor.getSource((ASTNode)oldExpression).equals(source)) {
                    ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            javaInfo.replaceExpression(oldExpression, source);
                        }
                    });
                }
            }
        } else if (source != null) {
            ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    javaInfo.addMethodInvocation(SetterAccessor.this.m_setterSignature, source);
                }
            });
        }
        return true;
    }

    @Override
    public Object getDefaultValue(JavaInfo javaInfo) throws Exception {
        return javaInfo.getArbitraryValue(this);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IAccessibleExpressionAccessor.class) {
            return adapter.cast(this.m_accessibleAccessor);
        }
        if (adapter == IExposableExpressionAccessor.class) {
            return adapter.cast(this.m_exposableAccessor);
        }
        if (adapter == PropertyTooltipProvider.class) {
            return adapter.cast(this.m_tooltipProvider);
        }
        return super.getAdapter(adapter);
    }

    private MethodInvocation getMethodInvocation(JavaInfo javaInfo) throws Exception {
        return javaInfo.getMethodInvocation(this.m_setterSignature);
    }

    private Expression getExpression(MethodInvocation invocation) {
        return invocation != null ? (Expression)invocation.arguments().get(0) : null;
    }
}

