/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeViewListener;
import org.eclipse.xtext.xbase.lib.Conversions;

@SuppressWarnings("all")
public class QueryRegistryTreeContentProvider implements ITreeContentProvider {
  protected TreeViewer viewer;
  
  protected QueryRegistryTreeInput input;
  
  @Override
  public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
    Preconditions.checkArgument((viewer instanceof TreeViewer));
    this.viewer = ((TreeViewer) viewer);
    if ((oldInput instanceof QueryRegistryTreeInput)) {
      QueryRegistryTreeViewListener _listener = ((QueryRegistryTreeInput)oldInput).getListener();
      _listener.provider = null;
    }
    if ((newInput instanceof QueryRegistryTreeInput)) {
      this.input = ((QueryRegistryTreeInput) newInput);
      QueryRegistryTreeViewListener _listener_1 = ((QueryRegistryTreeInput)newInput).getListener();
      _listener_1.provider = this;
    } else {
      if ((newInput != null)) {
        Class<?> _class = newInput.getClass();
        String _name = _class.getName();
        String _format = String.format("Invalid input type %s for List Viewer.", _name);
        throw new IllegalArgumentException(_format);
      }
    }
  }
  
  @Override
  public void dispose() {
  }
  
  @Override
  public Object[] getElements(final Object inputElement) {
    return this.getChildren(inputElement);
  }
  
  @Override
  public Object[] getChildren(final Object parentElement) {
    return this.getChildrenInternal(parentElement);
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreeInput parentElement) {
    Map<String, QueryRegistryTreeSource> _sources = parentElement.getSources();
    return ((Object[])Conversions.unwrapArray(_sources.values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreeSource parentElement) {
    Map<String, QueryRegistryTreePackage> _packages = parentElement.getPackages();
    return ((Object[])Conversions.unwrapArray(_packages.values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreePackage parentElement) {
    Map<String, QueryRegistryTreeEntry> _entries = parentElement.getEntries();
    return ((Object[])Conversions.unwrapArray(_entries.values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryRegistryTreeEntry parentElement) {
    return null;
  }
  
  @Override
  public Object getParent(final Object element) {
    return this.getParentInternal(element);
  }
  
  protected Object _getParentInternal(final QueryRegistryTreeInput element) {
    return null;
  }
  
  protected Object _getParentInternal(final QueryRegistryTreeSource element) {
    return element.getParent();
  }
  
  protected Object _getParentInternal(final QueryRegistryTreePackage element) {
    return element.getParent();
  }
  
  protected Object _getParentInternal(final QueryRegistryTreeEntry element) {
    return element.getParent();
  }
  
  @Override
  public boolean hasChildren(final Object element) {
    return this.hasChildrenInternal(element);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreeInput element) {
    Map<String, QueryRegistryTreeSource> _sources = element.getSources();
    boolean _isEmpty = _sources.isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreeSource element) {
    Map<String, QueryRegistryTreePackage> _packages = element.getPackages();
    boolean _isEmpty = _packages.isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreePackage element) {
    Map<String, QueryRegistryTreeEntry> _entries = element.getEntries();
    boolean _isEmpty = _entries.isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryRegistryTreeEntry element) {
    return false;
  }
  
  public Object[] getChildrenInternal(final Object parentElement) {
    if (parentElement instanceof QueryRegistryTreeEntry) {
      return _getChildrenInternal((QueryRegistryTreeEntry)parentElement);
    } else if (parentElement instanceof QueryRegistryTreeInput) {
      return _getChildrenInternal((QueryRegistryTreeInput)parentElement);
    } else if (parentElement instanceof QueryRegistryTreePackage) {
      return _getChildrenInternal((QueryRegistryTreePackage)parentElement);
    } else if (parentElement instanceof QueryRegistryTreeSource) {
      return _getChildrenInternal((QueryRegistryTreeSource)parentElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(parentElement).toString());
    }
  }
  
  public Object getParentInternal(final Object element) {
    if (element instanceof QueryRegistryTreeEntry) {
      return _getParentInternal((QueryRegistryTreeEntry)element);
    } else if (element instanceof QueryRegistryTreeInput) {
      return _getParentInternal((QueryRegistryTreeInput)element);
    } else if (element instanceof QueryRegistryTreePackage) {
      return _getParentInternal((QueryRegistryTreePackage)element);
    } else if (element instanceof QueryRegistryTreeSource) {
      return _getParentInternal((QueryRegistryTreeSource)element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
  
  public boolean hasChildrenInternal(final Object element) {
    if (element instanceof QueryRegistryTreeEntry) {
      return _hasChildrenInternal((QueryRegistryTreeEntry)element);
    } else if (element instanceof QueryRegistryTreeInput) {
      return _hasChildrenInternal((QueryRegistryTreeInput)element);
    } else if (element instanceof QueryRegistryTreePackage) {
      return _hasChildrenInternal((QueryRegistryTreePackage)element);
    } else if (element instanceof QueryRegistryTreeSource) {
      return _hasChildrenInternal((QueryRegistryTreeSource)element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
}
