/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum QueryBasedFeatureKind {
    SINGLE_REFERENCE,
    MANY_REFERENCE,
    SUM,
    ITERATION;

    private static final Map<String, QueryBasedFeatureKind> KIND_TEXT;

    static {
        KIND_TEXT = ImmutableMap.builder().put((Object)"single", (Object)SINGLE_REFERENCE).put((Object)"many", (Object)MANY_REFERENCE).put((Object)"sum", (Object)SUM).put((Object)"iteration", (Object)ITERATION).build();
    }

    public static QueryBasedFeatureKind parseKindString(String desc) {
        if (KIND_TEXT.containsKey(desc)) {
            return KIND_TEXT.get(desc);
        }
        return QueryBasedFeatureKind.valueOf(desc);
    }

    public static String getStringValue(QueryBasedFeatureKind kind) {
        if (SINGLE_REFERENCE.equals((Object)kind)) {
            return "single";
        }
        if (MANY_REFERENCE.equals((Object)kind)) {
            return "many";
        }
        if (SUM.equals((Object)kind)) {
            return "sum";
        }
        if (ITERATION.equals((Object)kind)) {
            return "iteration";
        }
        return null;
    }
}

