/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.counters.core.CounterAnalysis;
import org.eclipse.tracecompass.analysis.counters.ui.ITreeViewerListener;
import org.eclipse.tracecompass.internal.analysis.counters.ui.CounterTreeViewerEntry;
import org.eclipse.tracecompass.internal.analysis.counters.ui.TriStateFilteredCheckboxTree;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class CounterTreeViewer
extends AbstractTmfTreeViewer {
    private static final ViewerComparator COMPARATOR = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            TmfTreeViewerEntry entry1 = (TmfTreeViewerEntry)e1;
            TmfTreeViewerEntry entry2 = (TmfTreeViewerEntry)e2;
            String name1 = entry1.getName();
            String name2 = entry2.getName();
            Long longValue1 = Longs.tryParse((String)name1);
            Long longValue2 = Longs.tryParse((String)name2);
            return longValue1 == null || longValue2 == null ? name1.compareTo(name2) : longValue1.compareTo(longValue2);
        }
    };
    private ITreeViewerListener fListener;
    private TriStateFilteredCheckboxTree fCheckboxTree;
    private Map<ITmfTrace, Object[]> fViewContext = new HashMap<ITmfTrace, Object[]>();
    private Map<ITmfTrace, TmfTreeViewerEntry> fRoots = new HashMap<ITmfTrace, TmfTreeViewerEntry>();

    public CounterTreeViewer(Composite parent, TriStateFilteredCheckboxTree checkboxTree) {
        super(parent, checkboxTree.getViewer());
        TreeViewer treeViewer = checkboxTree.getViewer();
        treeViewer.setComparator(COMPARATOR);
        if (treeViewer instanceof CheckboxTreeViewer) {
            ((CheckboxTreeViewer)treeViewer).addCheckStateListener((ICheckStateListener)new CheckStateChangedListener());
        }
        this.fCheckboxTree = checkboxTree;
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element instanceof TmfTreeViewerEntry ? ((TmfTreeViewerEntry)element).getName() : super.getText(element);
            }
        });
    }

    public void setTreeListener(ITreeViewerListener listener) {
        this.fListener = listener;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        if (this.fRoots.containsKey(trace)) {
            return;
        }
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        this.fRoots.put(trace, root);
        @NonNull Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CounterAnalysis.class);
        for (CounterAnalysis module : modules) {
            ITmfTrace moduleTrace = module.getTrace();
            if (moduleTrace == null) continue;
            TmfTreeViewerEntry rootBranch = new TmfTreeViewerEntry(moduleTrace.getName());
            root.addChild(rootBranch);
            module.schedule();
            module.waitForCompletion();
            ITmfStateSystem stateSystem = module.getStateSystem();
            if (stateSystem == null) continue;
            this.addTreeViewerBranch(stateSystem, rootBranch, "Grouped");
            this.addTreeViewerBranch(stateSystem, rootBranch, "Ungrouped");
        }
    }

    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
        Object[] checkedElements = this.fViewContext.get(this.getTrace());
        this.fCheckboxTree.setCheckedElements(checkedElements != null ? checkedElements : new Object[]{});
        if (this.fListener != null) {
            this.fListener.handleCheckStateChangedEvent(this.getCheckedCounterEntries());
        }
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> {
            TmfTreeColumnData column = new TmfTreeColumnData("Counters");
            return Collections.singletonList(column);
        };
    }

    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        return (ITmfTreeViewerEntry)this.fRoots.get(this.getTrace());
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        this.saveViewContext();
        super.traceOpened(signal);
    }

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        if (signal != null && this.getTrace() != signal.getTrace()) {
            this.saveViewContext();
        }
        super.traceSelected(signal);
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        if (signal != null) {
            this.fViewContext.remove(signal.getTrace());
            this.fRoots.remove(signal.getTrace());
        }
        super.traceClosed(signal);
    }

    private void saveViewContext() {
        ITmfTrace previousTrace = this.getTrace();
        Object[] checkedElements = this.fCheckboxTree.getCheckedElements();
        if (previousTrace != null) {
            this.fViewContext.put(previousTrace, checkedElements);
        }
    }

    private void addTreeViewerBranch(ITmfStateSystem stateSystem, TmfTreeViewerEntry rootBranch, String branchName) {
        int quark = stateSystem.optQuarkAbsolute(new String[]{branchName});
        if (quark != -2 && !stateSystem.getSubAttributes(quark, false).isEmpty()) {
            TmfTreeViewerEntry branch = new TmfTreeViewerEntry(branchName);
            rootBranch.addChild(branch);
            this.addTreeViewerEntries(stateSystem, branch, quark);
        }
    }

    private void addTreeViewerEntries(ITmfStateSystem stateSystem, TmfTreeViewerEntry parentBranch, int quark) {
        Iterator iterator = stateSystem.getSubAttributes(quark, false).iterator();
        while (iterator.hasNext()) {
            TmfTreeViewerEntry childBranch;
            int childQuark = (Integer)iterator.next();
            if (stateSystem.getSubAttributes(childQuark, false).isEmpty()) {
                String fullPath = String.valueOf(this.retrieveTraceName((ITmfTreeViewerEntry)parentBranch)) + '/' + stateSystem.getFullAttributePath(childQuark);
                childBranch = new CounterTreeViewerEntry(childQuark, stateSystem, fullPath);
            } else {
                childBranch = new TmfTreeViewerEntry(stateSystem.getAttributeName(childQuark));
            }
            parentBranch.addChild(childBranch);
            this.addTreeViewerEntries(stateSystem, childBranch, childQuark);
        }
    }

    private String retrieveTraceName(ITmfTreeViewerEntry entry) {
        if (entry.getParent().getParent() == null) {
            return entry.getName();
        }
        return this.retrieveTraceName(entry.getParent());
    }

    private Iterable<ITmfTreeViewerEntry> getCheckedCounterEntries() {
        Object[] checkedElements = this.fCheckboxTree.getCheckedElements();
        return Iterables.filter(Arrays.asList(checkedElements), ITmfTreeViewerEntry.class);
    }

    private final class CheckStateChangedListener
    implements ICheckStateListener {
        private CheckStateChangedListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (CounterTreeViewer.this.fListener != null) {
                CounterTreeViewer.this.fListener.handleCheckStateChangedEvent(CounterTreeViewer.this.getCheckedCounterEntries());
            }
        }
    }
}

