/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui;

import com.google.common.collect.Iterables;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.counters.ui.ITreeViewerListener;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.analysis.counters.ui.CounterTreeViewerEntry;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;

public final class CounterChartViewer
extends TmfCommonXLineChartViewer
implements ITreeViewerListener {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(CounterChartViewer.class);
    private boolean isCumulative = false;
    private Iterable<ITmfTreeViewerEntry> fEntries = Collections.emptyList();

    public CounterChartViewer(Composite parent) {
        super(parent, null, null, null);
        Chart chart = this.getSwtChart();
        chart.getLegend().setPosition(1024);
        chart.getLegend().setVisible(true);
        chart.setBackground(Display.getDefault().getSystemColor(22));
    }

    public void toggleCumulative() {
        this.cancelUpdate();
        this.isCumulative ^= true;
        this.updateContent();
    }

    @Override
    public void handleCheckStateChangedEvent(Iterable<ITmfTreeViewerEntry> entries) {
        this.cancelUpdate();
        this.clearContent();
        this.fEntries = entries;
        this.updateContent();
    }

    /*
     * Unable to fully structure code
     */
    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        xAxis = CounterChartViewer.getXAxis((long)start, (long)end, (int)nb);
        if (xAxis.length == 1) {
            return;
        }
        Display.getDefault().syncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(org.eclipse.core.runtime.IProgressMonitor double[] ), ()V)((CounterChartViewer)this, (IProgressMonitor)monitor, (double[])xAxis));
        try {
            var8_6 = null;
            var9_9 = null;
            try {
                log = new TraceCompassLogUtils.ScopeLog(CounterChartViewer.LOGGER, Level.FINE, "CounterChartViewer#updateData", new Object[0]);
                try {
                    var12_12 = Iterables.filter(this.fEntries, CounterTreeViewerEntry.class).iterator();
                    while (true) {
                        counterEntry = (CounterTreeViewerEntry)var12_12.next();
                        if (monitor.isCanceled()) {
                            return;
                        }
                        steps = new double[xAxis.length];
                        ss = counterEntry.getStateSystem();
                        quark = counterEntry.getQuark();
                        stateSystemStartTime = ss.getStartTime();
                        stateSystemEndTime = ss.getCurrentEndTime();
                        prevTime = Math.max(stateSystemStartTime, (long)((double)start - xAxis[1]));
                        if (prevTime <= stateSystemEndTime) {
                            prev = ss.querySingleState(prevTime, quark.intValue()).getValue();
                            prevValue = prev instanceof Long != false ? (Long)prev : 0L;
                            i = 0;
                            while (i < xAxis.length) {
                                nextTime = start + (long)xAxis[i] - 1L;
                                if (nextTime >= stateSystemStartTime && nextTime <= stateSystemEndTime) {
                                    next = ss.querySingleState(nextTime, quark.intValue()).getValue();
                                    nextValue = next instanceof Long != false ? (Long)next : 0L;
                                    differentialValue = next == null ? 0L : nextValue - prevValue;
                                    steps[i] = this.isCumulative != false ? nextValue : differentialValue;
                                    prevValue = nextValue;
                                } else if (this.isCumulative) {
                                    steps[i] = prevValue;
                                }
                                ++i;
                            }
                        }
                        Display.getDefault().syncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(org.eclipse.core.runtime.IProgressMonitor org.eclipse.tracecompass.internal.analysis.counters.ui.CounterTreeViewerEntry double[] ), ()V)((CounterChartViewer)this, (IProgressMonitor)monitor, (CounterTreeViewerEntry)counterEntry, (double[])steps));
                        break;
                    }
                }
                finally {
                    if (var12_12.hasNext()) ** continue;
                }
            }
            catch (Throwable var9_10) {
                if (var8_6 == null) {
                    var8_6 = var9_10;
                } else if (var8_6 != var9_10) {
                    var8_6.addSuppressed(var9_10);
                }
                throw var8_6;
            }
        }
        catch (StateSystemDisposedException e) {
            return;
        }
        this.updateDisplay();
    }

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        this.fEntries = Collections.emptyList();
    }

    private /* synthetic */ void lambda$0(IProgressMonitor iProgressMonitor, double[] dArray) {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        this.setXAxis(dArray);
    }

    private /* synthetic */ void lambda$1(IProgressMonitor iProgressMonitor, CounterTreeViewerEntry counterTreeViewerEntry, double[] dArray) {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        this.setSeries(counterTreeViewerEntry.getFullPath(), dArray);
    }
}

