/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GenerateExternalsPropertyOperation
extends AbstractActionOperation
implements IResourcePropertyProvider {
    protected IResource resource;
    protected String url;
    protected SVNRevision revision;
    protected String localPath;
    protected boolean isPriorToSVN15Format;
    protected SVNProperty property;

    public GenerateExternalsPropertyOperation(IResource resource, String url, SVNRevision revision, String localPath, boolean isPriorToSVN15Format) {
        super("Operation_GenerateExternalsProperty", SVNMessages.class);
        this.resource = resource;
        this.url = url;
        this.revision = revision;
        this.localPath = localPath;
        this.isPriorToSVN15Format = isPriorToSVN15Format;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.preprocessInputParameters();
        StringBuffer value = new StringBuffer();
        if (this.isPriorToSVN15Format) {
            value.append(this.localPath);
            if (this.getStrRevision() != null) {
                value.append(" -r ").append(this.getStrRevision());
            }
            value.append(" ").append(this.url);
        } else {
            if (this.getStrRevision() != null) {
                value.append("-r ").append(this.getStrRevision()).append(" ");
            }
            value.append(this.url);
            value.append(" ").append(this.localPath);
        }
        this.property = new SVNProperty("svn:externals", value.toString());
    }

    protected void preprocessInputParameters() {
        this.url = SVNUtility.encodeURL(this.url);
        if (this.localPath.contains(" ")) {
            this.localPath = "\"" + this.localPath + "\"";
        }
    }

    protected String getStrRevision() {
        long number;
        if (this.revision.getKind() == SVNRevision.Kind.NUMBER && (number = ((SVNRevision.Number)this.revision).getNumber()) != -1L) {
            return String.valueOf(number);
        }
        return null;
    }

    public SVNProperty[] getProperties() {
        return new SVNProperty[]{this.property};
    }

    public IResource getLocal() {
        return this.resource;
    }

    public IRepositoryResource getRemote() {
        return SVNRemoteStorage.instance().asRepositoryResource(this.resource);
    }

    public boolean isEditAllowed() {
        return false;
    }

    public void refresh() {
    }
}

