/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.jobs;

import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.xtendxpand.jobs.AbstractM2xResultHandler;
import org.eclipse.sphinx.xtendxpand.jobs.CheckJob;
import org.eclipse.sphinx.xtendxpand.jobs.XpandJob;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.swt.widgets.Display;

public class ResultMessageHandler
extends AbstractM2xResultHandler {
    private int openDialogOn;

    public ResultMessageHandler() {
        this(0);
    }

    public ResultMessageHandler(int openDialogOn) {
        this.openDialogOn = openDialogOn;
    }

    public void handleResult(Job m2xJob) {
        this.handleResultMessage();
    }

    protected void handleResultMessage() {
        Display display = ExtendedPlatformUI.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    XpandJob xpandJob = ResultMessageHandler.this.getXpandJob();
                    String title = xpandJob != null ? Messages.title_codeGen : Messages.title_modelTransformation;
                    String m2xOperationName = xpandJob != null ? Messages.msg_codeGen : Messages.msg_modelTransformation;
                    CheckJob checkJob = ResultMessageHandler.this.getCheckJob();
                    if (checkJob != null && checkJob.getResult() != null && checkJob.getResult().getSeverity() == 4) {
                        MessageDialog dialog = new MessageDialog(ExtendedPlatformUI.getActiveShell(), title, null, ResultMessageHandler.this.capMessage(NLS.bind((String)Messages.msg_M2x_Check_operation_failed, (Object)m2xOperationName)), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.open();
                        return;
                    }
                    String message = "";
                    int imageType = -1;
                    IStatus m2xResultStatus = ResultMessageHandler.this.getM2xJob().getResult();
                    switch (ResultMessageHandler.this.openDialogOn) {
                        case 1: {
                            if (m2xResultStatus.getSeverity() != 0) break;
                            message = ResultMessageHandler.this.capMessage(NLS.bind((String)Messages.msg_M2x_operation_successful, (Object)m2xOperationName));
                            imageType = 2;
                            break;
                        }
                        case 2: {
                            if (m2xResultStatus != null && m2xResultStatus.getSeverity() == 0) {
                                message = ResultMessageHandler.this.capMessage(NLS.bind((String)Messages.msg_M2x_operation_successful, (Object)m2xOperationName));
                                imageType = 2;
                                break;
                            }
                            if (m2xResultStatus == null || m2xResultStatus.getSeverity() != 8) break;
                            message = ResultMessageHandler.this.capMessage(NLS.bind((String)Messages.msg_M2x_operation_canceled, (Object)m2xOperationName));
                            imageType = 1;
                            break;
                        }
                    }
                    if (message.length() > 0 && imageType != -1) {
                        MessageDialog dialog = new MessageDialog(ExtendedPlatformUI.getActiveShell(), title, null, message, imageType, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.open();
                    }
                }
            });
        }
    }

    protected String capMessage(String message) {
        if (message.length() > 0) {
            return String.valueOf(message.substring(0, 1).toUpperCase(Locale.getDefault())) + message.substring(1);
        }
        return message;
    }
}

