/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;

public class ModelResourceDescriptor {
    private URI uri;
    private String contentTypeId;
    private List<EObject> contents;

    public ModelResourceDescriptor(URI uri, String contentTypeId, EObject content) {
        this(uri, contentTypeId, Collections.singletonList(content));
    }

    public ModelResourceDescriptor(IPath path, String contentTypeId, EObject content) {
        this(EcorePlatformUtil.createURI(path), contentTypeId, Collections.singletonList(content));
    }

    public ModelResourceDescriptor(URI uri, String contentTypeId, List<EObject> contents) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull(contents);
        this.uri = uri;
        this.contentTypeId = contentTypeId;
        this.contents = contents;
    }

    public ModelResourceDescriptor(IPath path, String contentTypeId, List<EObject> contents) {
        this(EcorePlatformUtil.createURI(path), contentTypeId, contents);
    }

    @Deprecated
    public ModelResourceDescriptor(Collection<EObject> contents, IPath path, String contentTypeId) {
        this(EcorePlatformUtil.createURI(path), contentTypeId, new ArrayList<EObject>(contents));
    }

    @Deprecated
    public Collection<EObject> getModelRoots() {
        return this.getContents();
    }

    public URI getURI() {
        return this.uri;
    }

    public IPath getPath() {
        return EcorePlatformUtil.createPath(this.uri);
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    public List<EObject> getContents() {
        return this.contents;
    }
}

