/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.api.AbstractEEFEclipsePlugin;
import org.eclipse.eef.ide.api.extensions.AbstractRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.IItemDescriptor;
import org.eclipse.eef.ide.api.extensions.IItemRegistry;
import org.eclipse.eef.ide.api.extensions.impl.DescriptorRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.impl.ItemRegistry;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.core.api.DefaultDescriptionConverter;
import org.eclipse.sirius.properties.core.api.DefaultDescriptionWithInitialOperationConverter;
import org.eclipse.sirius.properties.core.api.IDescriptionConverter;
import org.eclipse.sirius.properties.core.api.IDescriptionLinkResolver;
import org.eclipse.sirius.properties.core.api.IDescriptionPreprocessor;
import org.eclipse.sirius.properties.core.internal.converter.PropertiesDescriptionConverterSwitch;
import org.eclipse.sirius.properties.core.internal.converter.PropertyValidationRuleLinkResolver;
import org.eclipse.sirius.properties.core.internal.converter.SemanticValidationRuleDescriptionConverter;
import org.eclipse.sirius.properties.core.internal.preprocessor.GroupDescriptionPreprocessorLinkResolver;
import org.eclipse.sirius.properties.core.internal.preprocessor.PropertiesDescriptionPreprocessorSwitch;
import org.eclipse.sirius.properties.core.internal.preprocessor.PropertyValidationRulePreprocessorLinkResolver;
import org.eclipse.sirius.tools.internal.validation.EValidatorAdapter;
import org.eclipse.sirius.viewpoint.description.validation.RuleAudit;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.osgi.framework.BundleContext;

public class SiriusPropertiesCorePlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.sirius.properties.core";
    public static final SiriusPropertiesCorePlugin INSTANCE = new SiriusPropertiesCorePlugin();
    private static Implementation plugin;

    public SiriusPropertiesCorePlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends AbstractEEFEclipsePlugin {
        private static final String DESCRIPTION_CONVERTER_EXTENSION_POINT = "descriptionConverter";
        private static final String DESCRIPTION_PREPROCESSOR_EXTENSION_POINT = "descriptionPreprocessor";
        private static final String DESCRIPTION_CONVERTER_LINK_RESOLVER_EXTENSION_POINT = "descriptionLinkResolver";
        private static final String DESCRIPTION_PREPROCESSOR_LINK_RESOLVER_EXTENSION_POINT = "descriptionPreprocessorLinkResolver";
        private IItemRegistry<IDescriptionConverter> descriptionConverterRegistry;
        private IItemRegistry<IDescriptionPreprocessor> descriptionPreprocessorRegistry;
        private IItemRegistry<IDescriptionLinkResolver> descriptionConverterLinkResolverRegistry;
        private IItemRegistry<IDescriptionLinkResolver> descriptionPreprocessorLinkResolverRegistry;
        private AbstractRegistryEventListener descriptionConverterListener;
        private AbstractRegistryEventListener descriptionPreprocessorListener;
        private AbstractRegistryEventListener descriptionConverterLinkResolverListener;
        private AbstractRegistryEventListener descriptionPreprocessorLinkResolverListener;
        private boolean hasReadDescriptionConverterRegistry;
        private boolean hasReadDescriptionConverterLinkResolverRegistry;
        private boolean hasReadDescriptionPreprocessorRegistry;
        private boolean hasReadDescriptionPreprocessorLinkResolverRegistry;

        public Implementation() {
            super(SiriusPropertiesCorePlugin.PLUGIN_ID);
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            EValidator.Registry.INSTANCE.put((Object)PropertiesPackage.eINSTANCE, (Object)new EValidatorAdapter());
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.descriptionConverterRegistry = new ItemRegistry();
            this.descriptionConverterListener = new DescriptorRegistryEventListener(SiriusPropertiesCorePlugin.PLUGIN_ID, DESCRIPTION_CONVERTER_EXTENSION_POINT, this.descriptionConverterRegistry);
            registry.addListener((IRegistryEventListener)this.descriptionConverterListener, "org.eclipse.sirius.properties.core.descriptionConverter");
            this.descriptionPreprocessorRegistry = new ItemRegistry();
            this.descriptionPreprocessorListener = new DescriptorRegistryEventListener(SiriusPropertiesCorePlugin.PLUGIN_ID, DESCRIPTION_PREPROCESSOR_EXTENSION_POINT, this.descriptionPreprocessorRegistry);
            registry.addListener((IRegistryEventListener)this.descriptionPreprocessorListener, "org.eclipse.sirius.properties.core.descriptionPreprocessor");
            this.descriptionConverterLinkResolverRegistry = new ItemRegistry();
            this.descriptionConverterLinkResolverListener = new DescriptorRegistryEventListener(SiriusPropertiesCorePlugin.PLUGIN_ID, DESCRIPTION_CONVERTER_LINK_RESOLVER_EXTENSION_POINT, this.descriptionConverterLinkResolverRegistry);
            registry.addListener((IRegistryEventListener)this.descriptionConverterLinkResolverListener, "org.eclipse.sirius.properties.core.descriptionLinkResolver");
            this.descriptionPreprocessorLinkResolverRegistry = new ItemRegistry();
            this.descriptionPreprocessorLinkResolverListener = new DescriptorRegistryEventListener(SiriusPropertiesCorePlugin.PLUGIN_ID, DESCRIPTION_PREPROCESSOR_LINK_RESOLVER_EXTENSION_POINT, this.descriptionPreprocessorLinkResolverRegistry);
            registry.addListener((IRegistryEventListener)this.descriptionPreprocessorLinkResolverListener, "org.eclipse.sirius.properties.core.descriptionPreprocessorLinkResolver");
        }

        public void stop(BundleContext context) throws Exception {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.descriptionConverterListener);
            registry.removeListener((IRegistryEventListener)this.descriptionConverterLinkResolverListener);
            registry.removeListener((IRegistryEventListener)this.descriptionPreprocessorListener);
            registry.removeListener((IRegistryEventListener)this.descriptionPreprocessorLinkResolverListener);
            this.descriptionConverterListener = null;
            this.descriptionConverterRegistry = null;
            this.descriptionConverterLinkResolverListener = null;
            this.descriptionConverterLinkResolverRegistry = null;
            this.descriptionPreprocessorListener = null;
            this.descriptionPreprocessorRegistry = null;
            this.descriptionPreprocessorLinkResolverListener = null;
            this.descriptionPreprocessorLinkResolverRegistry = null;
            super.stop(context);
        }

        public Optional<IDescriptionConverter> getDescriptionConverter(EObject description) {
            List itemDescriptors;
            Optional converter;
            if (!this.hasReadDescriptionConverterRegistry) {
                this.descriptionConverterListener.readRegistry(Platform.getExtensionRegistry());
                this.hasReadDescriptionConverterRegistry = true;
            }
            if (!(converter = (itemDescriptors = this.descriptionConverterRegistry.getItemDescriptors()).stream().map(IItemDescriptor::getItem).filter(descriptionConverter -> descriptionConverter.canHandle(description)).findFirst()).isPresent()) {
                if (description instanceof SemanticValidationRule) {
                    converter = Optional.of(new SemanticValidationRuleDescriptionConverter());
                } else if (description instanceof RuleAudit) {
                    converter = Optional.of(new DefaultDescriptionConverter<RuleAudit>(RuleAudit.class, EefPackage.Literals.EEF_RULE_AUDIT_DESCRIPTION));
                } else if (description instanceof ValidationFix) {
                    converter = Optional.of(new DefaultDescriptionWithInitialOperationConverter<ValidationFix>(ValidationFix.class, EefPackage.Literals.EEF_VALIDATION_FIX_DESCRIPTION, EefPackage.Literals.EEF_VALIDATION_FIX_DESCRIPTION__FIX_EXPRESSION));
                } else {
                    PropertiesDescriptionConverterSwitch descriptionConverterSwitch = new PropertiesDescriptionConverterSwitch();
                    converter = (Optional)descriptionConverterSwitch.doSwitch(description);
                }
            }
            return converter;
        }

        public Optional<IDescriptionPreprocessor> getDescriptionPreprocessor(EObject description) {
            List itemDescriptors;
            Optional preprocessor;
            if (!this.hasReadDescriptionPreprocessorRegistry) {
                this.descriptionPreprocessorListener.readRegistry(Platform.getExtensionRegistry());
                this.hasReadDescriptionPreprocessorRegistry = true;
            }
            if (!(preprocessor = (itemDescriptors = this.descriptionPreprocessorRegistry.getItemDescriptors()).stream().map(IItemDescriptor::getItem).filter(descriptionPreprocessor -> descriptionPreprocessor.canHandle(description)).findFirst()).isPresent()) {
                PropertiesDescriptionPreprocessorSwitch descriptionPreprocessorSwitch = new PropertiesDescriptionPreprocessorSwitch();
                preprocessor = (Optional)descriptionPreprocessorSwitch.doSwitch(description);
            }
            return preprocessor;
        }

        public List<IDescriptionLinkResolver> getDescriptionConverterLinkResolvers() {
            if (!this.hasReadDescriptionConverterLinkResolverRegistry) {
                this.descriptionConverterLinkResolverListener.readRegistry(Platform.getExtensionRegistry());
                this.hasReadDescriptionConverterLinkResolverRegistry = true;
            }
            ArrayList<IDescriptionLinkResolver> linkResolvers = new ArrayList<IDescriptionLinkResolver>();
            linkResolvers.add(new PropertyValidationRuleLinkResolver());
            List itemDescriptors = this.descriptionConverterLinkResolverRegistry.getItemDescriptors();
            itemDescriptors.stream().map(IItemDescriptor::getItem).map(linkResolvers::add);
            return linkResolvers;
        }

        public List<IDescriptionLinkResolver> getDescriptionPreprocessorLinkResolvers() {
            if (!this.hasReadDescriptionPreprocessorLinkResolverRegistry) {
                this.descriptionPreprocessorLinkResolverListener.readRegistry(Platform.getExtensionRegistry());
                this.hasReadDescriptionPreprocessorLinkResolverRegistry = true;
            }
            ArrayList<IDescriptionLinkResolver> linkResolvers = new ArrayList<IDescriptionLinkResolver>();
            linkResolvers.add(new GroupDescriptionPreprocessorLinkResolver());
            linkResolvers.add(new PropertyValidationRulePreprocessorLinkResolver());
            List itemDescriptors = this.descriptionPreprocessorLinkResolverRegistry.getItemDescriptors();
            itemDescriptors.stream().map(IItemDescriptor::getItem).map(linkResolvers::add);
            return linkResolvers;
        }
    }
}

