/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonsGroup
extends Composite {
    private final boolean vertical;
    private final List<Button> buttons;
    private final List<Button> buttonsReadOnly;
    private final Map<Button, Control> auxTextControls;
    private SelectionListener selectionListener;
    private Button selection;
    private List<SelectionListener> listeners;

    public RadioButtonsGroup(Composite composite, boolean vertical) {
        super(composite, 0);
        this.vertical = vertical;
        this.buttons = new ArrayList<Button>();
        this.buttonsReadOnly = Collections.unmodifiableList(this.buttons);
        this.auxTextControls = new HashMap<Button, Control>();
        this.selection = null;
        this.listeners = new CopyOnWriteArrayList<SelectionListener>();
        if (this.vertical) {
            this.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        } else {
            RowLayout layout = new RowLayout();
            layout.wrap = false;
            layout.pack = true;
            layout.type = vertical ? 512 : 256;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.spacing = 5;
            this.setLayout((Layout)layout);
        }
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RadioButtonsGroup.this.handleWidgetSelectedEvent(event);
            }
        };
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        SwtUtil.setEnabledOnChildren(this, enabled);
    }

    public List<Button> getRadioButtons() {
        return this.buttonsReadOnly;
    }

    public Button addRadioButton(String text) {
        return this.addRadioButton(text, null, null);
    }

    public Button addRadioButton(String text, String auxText, Image image) {
        final Button button = new Button((Composite)this, 16);
        button.setLayoutData(this.vertical ? GridLayoutUtil.gd() : null);
        button.setText(text);
        this.buttons.add(button);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RadioButtonsGroup.this.buttons.remove(button);
                Control auxTextControl = (Control)RadioButtonsGroup.this.auxTextControls.remove(button);
                if (auxTextControl != null) {
                    auxTextControl.dispose();
                }
            }
        });
        button.addSelectionListener(this.selectionListener);
        if (this.vertical && auxText != null) {
            Composite auxTextComposite = new Composite((Composite)this, 0);
            auxTextComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
            auxTextComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 16, 0, 0, 0));
            Label auxTextLabel = new Label(auxTextComposite, 64);
            auxTextLabel.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 100));
            auxTextLabel.setForeground(this.getDisplay().getSystemColor(16));
            auxTextLabel.setText(auxText);
            SwtUtil.reflowOnResize((Control)auxTextLabel);
            this.auxTextControls.put(button, (Control)auxTextComposite);
        }
        if (image != null) {
            button.setImage(image);
        }
        return button;
    }

    public void removeRadioButton(Button button) {
        button.dispose();
    }

    public Button getSelection() {
        return this.selection;
    }

    public void setSelection(Button button) {
        this.selection = button;
        SwtUtil.changeRadioButtonSelection(this.buttons, button);
    }

    public int getSelectionIndex() {
        Button selection = this.getSelection();
        return selection == null ? -1 : this.buttons.indexOf(selection);
    }

    public void setSelectionIndex(int selection) {
        this.setSelection(this.buttons.get(selection));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void handleWidgetSelectedEvent(SelectionEvent event) {
        Button b = (Button)event.getSource();
        if (b.getSelection()) {
            this.selection = b;
            for (SelectionListener listener : this.listeners) {
                try {
                    listener.widgetSelected(event);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
        }
    }
}

