/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.widgets.FileDialog;

public class AbsoluteFilePathBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "Sapphire.Browse.File.Absolute";
    public static final String PARAM_EXTENSIONS = "extensions";
    @Text(value="absolute &file path")
    private static LocalizableText label;
    private FileExtensionsService fileExtensionService;
    private List<String> staticFileExtensionsList;

    static {
        LocalizableText.init(AbsoluteFilePathBrowseActionHandler.class);
    }

    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.setLabel(label.text());
        this.addImage((ImageData)ImageData.readFromClassLoader(AbsoluteFilePathBrowseActionHandler.class, (String)"File.png").required());
        String staticFileExtensions = def.getParam(PARAM_EXTENSIONS);
        if (staticFileExtensions == null) {
            this.fileExtensionService = (FileExtensionsService)this.property().service(FileExtensionsService.class);
            if (this.fileExtensionService == null) {
                this.staticFileExtensionsList = Collections.emptyList();
            }
        } else {
            this.staticFileExtensionsList = new ArrayList<String>();
            String[] stringArray = staticFileExtensions.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if ((extension = extension.trim()).length() > 0) {
                    this.staticFileExtensionsList.add(extension);
                }
                ++n2;
            }
        }
    }

    @Override
    protected String browse(Presentation context) {
        List extensions;
        Value<?> property = this.property();
        FileDialog dialog = new FileDialog(((FormComponentPresentation)context).shell());
        dialog.setText(property.definition().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        Value<?> value = property;
        Path path = (Path)value.content();
        if (path != null && path.segmentCount() > 1) {
            dialog.setFilterPath(path.removeLastSegments(1).toOSString());
            dialog.setFileName(path.lastSegment());
        }
        if (!(extensions = this.fileExtensionService == null ? this.staticFileExtensionsList : this.fileExtensionService.extensions()).isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String extension : extensions) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append("*.");
                buf.append(extension);
            }
            dialog.setFilterExtensions(new String[]{buf.toString()});
        }
        return dialog.open();
    }
}

