/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.layout;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.StandardEmbeddedConnectionPart;

public class ConnectionHashKey {
    private String nodeId;
    private String connectionId;

    private ConnectionHashKey(String nodeId, String connectionId) {
        this.nodeId = nodeId;
        this.connectionId = connectionId;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof ConnectionHashKey) {
            ConnectionHashKey hashKey = (ConnectionHashKey)object;
            String nodeId = hashKey.getNodeId();
            String connectionId = hashKey.getConnectionId();
            boolean nodeIdEqual = nodeId == null && this.nodeId == null || nodeId != null && this.nodeId != null && nodeId.equals(this.nodeId);
            boolean connIdEqual = connectionId.equals(this.connectionId);
            isEqual = nodeIdEqual && connIdEqual;
        }
        return isEqual;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int hashCode() {
        if (this.nodeId != null) {
            return this.nodeId.hashCode() ^ this.connectionId.hashCode();
        }
        return this.connectionId.hashCode();
    }

    public static ConnectionHashKey createKey(DiagramConnectionPart connPart) {
        SapphireDiagramEditorPagePart diagramPart = connPart.nearest(SapphireDiagramEditorPagePart.class);
        String connId = connPart.getId();
        String nodeId = null;
        if (connPart instanceof StandardEmbeddedConnectionPart) {
            Element srcElement = connPart.getEndpoint1();
            DiagramNodePart nodePart = diagramPart.getDiagramNodePart(srcElement);
            nodeId = nodePart.getId();
        }
        ConnectionHashKey hashKey = new ConnectionHashKey(nodeId, connId);
        return hashKey;
    }

    public static ConnectionHashKey createKey(String nodeId, String connId) {
        return new ConnectionHashKey(nodeId, connId);
    }
}

