/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.wizards.types.NewPHPElementData;
import org.eclipse.php.internal.ui.wizards.types.TextTemplate;
import org.osgi.framework.Bundle;

public abstract class PHPElementTemplate
extends TextTemplate {
    public static final String INPUT = "input";
    public static final String PHP_CONTENT_STRUCT = "php_content";
    public static final String PHP_CONTENT_STRUCT_COMPILED = "php_content_compiled";
    public static final String CLASS_STRUCT = "class";
    public static final String CLASS_STRUCT_COMPILED = "class_compiled";
    public static final String CLASS_NAME_VAR = "class_name";
    public static final String ELEMENT_TYPE_VAR = "element_type";
    public static final String FUNC_PHPDOC_STRUCT = "func_phpdoc";
    public static final String FUNC_PHPDOC_STRUCT_COMPILED = "func_phpdoc_compiled";
    public static final String FUNC_PHPDOC_PARAMS_STRUCT = "func_phpdoc_params";
    public static final String FUNC_PHPDOC_PARAMS_STRUCT_COMPILED = "func_phpdoc_params_compiled";
    public static final String FUNC_PHPDOC_PARAM_VAR = "func_phpdoc_param";
    public static final String FUNC_PHPDOC_SEE_VAR = "func_phpdoc_see";
    public static final String FUNC_PARAMS_STRUCT = "func_params";
    public static final String FUNC_PARAMS_STRUCT_COMPILED = "func_params_compiled";
    public static final String FUNC_PARAM_NAME_VAR = "func_param_name";
    public static final String FUNCTIONS_STRUCT = "functions";
    public static final String FUNCTIONS_STRUCT_COMPILED = "functions_compiled";
    public static final String FUNCTION_NAME_VAR = "func_name";
    public static final String FUNCTION_MODIFIER_VAR = "func_modifier";
    public static final String FUNCTION_STATIC_VAR = "func_static_modifier";
    public static final String FUNCTION_PARENT_CALL = "func_parent_call";
    public static final String REQUIRES_STRUCT = "requires";
    public static final String REQUIRES_STRUCT_COMPILED = "requires_compiled";
    public static final String REQUIRES_IN_FILE_STRUCT = "requires_in_file";
    public static final String REQUIRES_IN_FILE_STRUCT_COMPILED = "requires_in_file_compiled";
    public static final String REQUIRES_NAME_VAR = "require_location";
    public static final String SUPERCLASS_STRUCT = "superclass";
    public static final String SUPERCLASS_STRUCT_COMPILED = "superclass_compiled";
    public static final String SUPERCLASS_NAME_VAR = "superclass_name";
    public static final String INTERFACES_STRUCT = "interfaces";
    public static final String INTERFACES_STRUCT_COMPILED = "interfaces_compiled";
    public static final String INTERFACE_NAME_VAR = "interface_name";
    public static final String IMPLEMENTS_STRUCT = "implements";
    public static final String IMPLEMENTS_STRUCT_COMPILED = "implements_compiled";
    public static final String TRAITS_STRUCT = "traits";
    public static final String TRAITS_STRUCT_COMPILED = "traits_compiled";
    public static final String TRAIT_NAME_VAR = "trait_name";
    public static final String USESTRAITS_STRUCT = "usetrait";
    public static final String USESTRAITS_STRUCT_COMPILED = "usetrait_compiled";
    public static final String TODO_VAR = "todo_text";
    public static final String TODO_TEXT = "//TODO - Insert your code here";
    public static final String DEFAULT_PHPDOC_VAR = "default_phpdoc";
    public static final String DEFAULT_PHPDOC_TEXT = "/**\n *\n */";
    public static final String ABSTRACT_VAR = "abstract_var";
    public static final String FINAL_VAR = "final_var";
    public static final String ABSTRACT_TEXT = "abstract";
    public static final String FINAL_TEXT = "final";
    public static final String NAMESPACE_STRUCT = "namespace";
    public static final String NAMESPACE_NAME = "namespace_name";
    public static final String NAMESPACE_STRUCT_COMPILED = "namespace_compiled";
    public static final String NAMESPACE_IN_FILE_STRUCT = "namespace_in_file";
    public static final String NAMESPACE_IN_FILE_STRUCT_COMPILED = "namespace_in_file_compiled";
    public static final String USE_STRUCT = "use";
    public static final String USE = "use_full_name";
    public static final String USE_STRUCT_COMPILED = "use_compiled";
    public static final String USE_IN_FILE_STRUCT = "use_in_file";
    public static final String USE_IN_STRUCT_COMPILED = "use_in_file_compiled";
    public static final String[] EXCLUDE_PARAM_TYPES_LIST = new String[]{"boolean", "bool", "integer", "int", "float", "double", "string", "mixed", "void", "unknown_type"};

    public String resolveTemplate() throws IOException {
        return this.set(INPUT, this.readTemplate());
    }

    public String readTemplate() throws IOException {
        String line;
        URL url = FileLocator.find((Bundle)PHPUiPlugin.getDefault().getBundle(), (IPath)new Path(this.getTemplatePath()), null);
        url = FileLocator.resolve((URL)url);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
        StringBuilder buffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public String getVisibilityModifier(int modifiers) {
        if (Flags.isProtected((int)modifiers)) {
            return "protected";
        }
        if (Flags.isPublic((int)modifiers)) {
            return "public";
        }
        return "";
    }

    public boolean isStaticFunction(int funcModifiers) {
        return Flags.isStatic((int)funcModifiers);
    }

    public abstract String processTemplate(NewPHPElementData var1);

    public abstract String getRequiredPHPs();

    public abstract String getTemplatePath();

    protected boolean isImported(NewPHPElementData data, IType superClass) {
        String importEntry;
        String name = superClass.getElementName();
        try {
            IModelElement parent = superClass.getParent();
            if (parent instanceof IType && PHPFlags.isNamespace((int)((IType)parent).getFlags())) {
                name = String.valueOf(parent.getElementName()) + "\\" + name;
            }
        }
        catch (ModelException parent) {
            // empty catch block
        }
        if ((String.valueOf(data.realNamespace) + "\\" + superClass.getElementName()).equals(name)) {
            return true;
        }
        String[] stringArray = data.imports;
        int n = data.imports.length;
        int n2 = 0;
        while (n2 < n) {
            importEntry = stringArray[n2];
            if (importEntry.equals(name)) {
                return true;
            }
            ++n2;
        }
        stringArray = data.existingImports;
        n = data.existingImports.length;
        n2 = 0;
        while (n2 < n) {
            importEntry = stringArray[n2];
            if (importEntry.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getDefaultPHPDoc() {
        return "/** \n * @author " + System.getProperty("user.name") + "\n * \n */";
    }

    protected void handleRequires(NewPHPElementData data) {
        this.extract(INPUT, REQUIRES_STRUCT, REQUIRES_STRUCT_COMPILED);
        this.set(REQUIRES_STRUCT, "");
        this.extract(CLASS_STRUCT, REQUIRES_IN_FILE_STRUCT, REQUIRES_IN_FILE_STRUCT_COMPILED);
        this.set(REQUIRES_IN_FILE_STRUCT, "");
        if (data.isExistingFile && data.isInFirstBlock) {
            int i = 0;
            while (i < data.requiredToAdd.length) {
                this.set(REQUIRES_NAME_VAR, data.requiredToAdd[i]);
                this.compile(REQUIRES_IN_FILE_STRUCT_COMPILED, REQUIRES_IN_FILE_STRUCT, true);
                ++i;
            }
        } else {
            int i = 0;
            while (i < data.requiredToAdd.length) {
                this.set(REQUIRES_NAME_VAR, data.requiredToAdd[i]);
                this.compile(REQUIRES_STRUCT_COMPILED, REQUIRES_STRUCT, true);
                ++i;
            }
        }
    }
}

