/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.watch;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpEvalVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.watch.IWatchExpressionResultExtension;
import org.w3c.dom.Node;

public class XDebugWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String expressionText;
    private IWatchExpressionListener watchListener;
    private DBGpTarget debugTarget;
    private DBGpStackFrame stackFrame;
    private Job evalJob;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.expressionText = expression;
        this.watchListener = listener;
        IDebugTarget target = context.getDebugTarget();
        if (target instanceof DBGpTarget && context instanceof DBGpStackFrame) {
            this.debugTarget = (DBGpTarget)target;
            this.stackFrame = (DBGpStackFrame)context;
            if (!this.debugTarget.isSuspended()) {
                this.watchListener.watchEvaluationFinished(null);
            } else {
                this.evalJob = new EvaluationRunnable();
                this.evalJob.schedule();
            }
        } else {
            this.watchListener.watchEvaluationFinished(null);
        }
    }

    private final class EvaluationRunnable
    extends Job {
        public EvaluationRunnable() {
            super("XDEbugEvaluationRunnable");
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                XDebugWatchExpressionResult watchResult = new XDebugWatchExpressionResult();
                watchResult.evaluate();
                XDebugWatchExpressionDelegate.this.watchListener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
            }
            catch (Exception e) {
                Logger.logException(e);
                XDebugWatchExpressionDelegate.this.watchListener.watchEvaluationFinished(null);
            }
            return Status.OK_STATUS;
        }
    }

    private class XDebugWatchExpressionResult
    implements IWatchExpressionResult,
    IWatchExpressionResultExtension {
        private boolean hasErrors = false;
        private IValue evalResult;

        private XDebugWatchExpressionResult() {
        }

        void evaluate() {
            ISourceRange enclosingIdentifier;
            String watchExpression = XDebugWatchExpressionDelegate.this.expressionText.trim();
            Node result = null;
            String stackLevel = XDebugWatchExpressionDelegate.this.stackFrame.getStackLevel();
            DBGpVariable.Kind exprKind = DBGpVariable.Kind.EVAL;
            if (watchExpression.startsWith("$") && (enclosingIdentifier = PHPTextSequenceUtilities.getEnclosingIdentifier((CharSequence)watchExpression, (int)0)) != null && enclosingIdentifier.getLength() == watchExpression.length() + 1) {
                exprKind = DBGpVariable.Kind.STACK;
            }
            switch (exprKind) {
                case STACK: {
                    result = XDebugWatchExpressionDelegate.this.debugTarget.getProperty(watchExpression, stackLevel, 0);
                    if (result != null && !"error".equals(result.getNodeName())) break;
                    stackLevel = "-1";
                    result = XDebugWatchExpressionDelegate.this.debugTarget.getProperty(watchExpression, stackLevel, 0);
                    break;
                }
                default: {
                    result = XDebugWatchExpressionDelegate.this.debugTarget.eval(watchExpression);
                }
            }
            if (result != null) {
                DBGpEvalVariable tempVar;
                switch (exprKind) {
                    case STACK: {
                        tempVar = new DBGpStackVariable((IDebugTarget)XDebugWatchExpressionDelegate.this.debugTarget, result, Integer.valueOf(stackLevel).intValue(), new IVariableFacet.Facet[0]);
                        break;
                    }
                    default: {
                        tempVar = new DBGpEvalVariable((IDebugTarget)XDebugWatchExpressionDelegate.this.debugTarget, watchExpression, result, new IVariableFacet.Facet[0]);
                    }
                }
                this.evalResult = null;
                try {
                    this.evalResult = tempVar.getValue();
                    if (this.evalResult == null) {
                        this.hasErrors = true;
                    }
                }
                catch (Exception e) {
                    this.hasErrors = true;
                }
            } else {
                this.hasErrors = true;
            }
        }

        public IValue getValue() {
            return this.evalResult;
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public String[] getErrorMessages() {
            if (this.hasErrors) {
                return new String[]{PHPDebugUIMessages.XDebugWatch_failed};
            }
            return null;
        }

        public String getExpressionText() {
            return XDebugWatchExpressionDelegate.this.expressionText;
        }

        public DebugException getException() {
            return null;
        }

        @Override
        public IDebugTarget getDebugTarget() {
            return XDebugWatchExpressionDelegate.this.debugTarget;
        }
    }
}

