/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceUseConstNameContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class NamespaceUseConstNameStrategy
extends AbstractCompletionStrategy {
    public NamespaceUseConstNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof NamespaceUseConstNameContext)) {
            return;
        }
        NamespaceUseConstNameContext concreteContext = (NamespaceUseConstNameContext)context;
        String suffix = "";
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        IField[] iFieldArray = this.getFields(concreteContext);
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            reporter.reportField(field, suffix, replaceRange, false, 0, this.getExtraInfo());
            ++n2;
        }
    }

    public IField[] getFields(NamespaceUseConstNameContext context) throws BadLocationException {
        String prefix = context.getPrefix();
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = context.getNamespaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            try {
                IField[] iFieldArray = ns.getFields();
                int n3 = iFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField field = iFieldArray[n4];
                    if (StringUtils.startsWithIgnoreCase((CharSequence)field.getElementName(), (CharSequence)prefix)) {
                        result.add(field);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected int getExtraInfo() {
        return 577;
    }
}

