/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPThisClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class CodeAssistUtils {
    public static final int USE_PHPDOC = 32;
    private static final String DOLLAR = "$";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final String[] KEYWORD_FUNCTION_NAMES = new String[]{"return", "yield", "print", "echo"};
    private static final String NEW = "new";
    private static final Pattern globalPattern = Pattern.compile("\\$GLOBALS[ \\t\\n\\r]*\\[[ \\t\\n\\r]*[\\'\\\"][\\w]+[\\'\\\"][ \\t\\n\\r]*\\]");
    private static final IType[] EMPTY_TYPES = new IType[0];

    public static IType[] getVariableType(IType[] types, String propertyName, int offset) {
        if (types != null) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocClassVariableGoal phpDocGoal;
                IEvaluatedType evaluatedType;
                IType[] modelElements;
                IType type = iTypeArray[n2];
                PHPClassType classType = PHPClassType.fromIType(type);
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)type.getSourceModule(), null);
                FileContext fileContext = new FileContext(type.getSourceModule(), moduleDeclaration, offset);
                TypeContext typeContext = new TypeContext((ISourceModuleContext)fileContext, (IEvaluatedType)classType);
                PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
                if (!propertyName.startsWith(DOLLAR)) {
                    propertyName = DOLLAR + propertyName;
                }
                if ((modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal = new PHPDocClassVariableGoal(typeContext, propertyName, offset), 3000), (ISourceModuleContext)fileContext, offset)) != null) {
                    return modelElements;
                }
                ClassVariableDeclarationGoal goal = new ClassVariableDeclarationGoal((IContext)typeContext, types, propertyName);
                evaluatedType = typeInferencer.evaluateType(goal);
                modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)fileContext, offset);
                if (modelElements != null) {
                    return modelElements;
                }
                ++n2;
            }
        }
        return EMPTY_TYPES;
    }

    public static IType[] getArrayVariableType(ISourceModule sourceModule, String variableName, int position) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, position);
        if (context != null) {
            PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
            VariableReference varReference = CodeAssistUtils.getVariableReference(variableName, position);
            ExpressionTypeGoal goal = new ExpressionTypeGoal(context, (ASTNode)varReference);
            IEvaluatedType evaluatedType = typeInferencer.evaluateType((AbstractTypeGoal)goal);
            if (evaluatedType instanceof MultiTypeType || evaluatedType instanceof AmbiguousType) {
                return CodeAssistUtils.getTypes(position, context, evaluatedType);
            }
            IType[] modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)context, position);
            if (modelElements != null) {
                return modelElements;
            }
        }
        return EMPTY_TYPES;
    }

    private static IType[] getTypes(int position, IContext context, IEvaluatedType evaluatedType) {
        LinkedList<IType> tmpList = new LinkedList<IType>();
        List<IEvaluatedType> possibleTypes = new LinkedList();
        if (evaluatedType instanceof MultiTypeType) {
            possibleTypes = ((MultiTypeType)evaluatedType).getTypes();
        } else if (evaluatedType instanceof AmbiguousType) {
            possibleTypes.addAll(Arrays.asList(((AmbiguousType)evaluatedType).getPossibleTypes()));
        } else {
            possibleTypes.add(evaluatedType);
        }
        for (IEvaluatedType possibleType : possibleTypes) {
            IType[] tmpArray = possibleType instanceof MultiTypeType || possibleType instanceof AmbiguousType ? CodeAssistUtils.getTypes(position, context, possibleType) : PHPTypeInferenceUtils.getModelElements(possibleType, (ISourceModuleContext)context, position, null);
            if (tmpArray == null) continue;
            tmpList.addAll(Arrays.asList(tmpArray));
        }
        return tmpList.toArray(new IType[tmpList.size()]);
    }

    public static IType[] getVariableType(ISourceModule sourceModule, String variableName, int position) {
        VariableReference varReference;
        ExpressionTypeGoal goal;
        PHPTypeInferencer typeInferencer;
        IEvaluatedType evaluatedType;
        IType[] modelElements;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, position);
        if (context != null && (modelElements = CodeAssistUtils.getTypes(position, context, evaluatedType = (typeInferencer = new PHPTypeInferencer()).evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal(context, (ASTNode)(varReference = CodeAssistUtils.getVariableReference(variableName, position))))))) != null) {
            return modelElements;
        }
        return EMPTY_TYPES;
    }

    private static VariableReference getVariableReference(String variableName, int position) {
        String start = "";
        int arrayType = 0;
        if (variableName.endsWith("]")) {
            start = "[";
            arrayType = 1;
        } else if (variableName.endsWith("}")) {
            start = "{";
            arrayType = 2;
        }
        if (!"".equals(start)) {
            int startIndex = variableName.indexOf(start);
            String name = variableName.substring(0, startIndex);
            return new ArrayVariableReference(position, position + variableName.length(), name, null, arrayType);
        }
        return new VariableReference(position, position + variableName.length(), variableName);
    }

    public static IType[] getFunctionReturnType(IType[] types, String method, ISourceModule sourceModule, int offset) {
        return CodeAssistUtils.getFunctionReturnType(types, method, 32, sourceModule, offset);
    }

    public static IType[] getFunctionReturnType(IType[] types, String method, int mask, ISourceModule sourceModule, int offset) {
        return CodeAssistUtils.getFunctionReturnType(types, method, mask, sourceModule, offset, null);
    }

    public static IType[] getFunctionReturnType(IType[] types, String method, int mask, ISourceModule sourceModule, int offset, String[] argNames) {
        PHPDocMethodReturnTypeGoal phpDocGoal;
        IEvaluatedType evaluatedType;
        Object[] modelElements;
        boolean usePhpDoc;
        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, offset);
        boolean bl = usePhpDoc = (mask & 0x20) != 0;
        if (usePhpDoc && ArrayUtils.isNotEmpty((Object[])(modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal = new PHPDocMethodReturnTypeGoal(context, types, method, argNames, offset)), (ISourceModuleContext)context, offset)))) {
            return modelElements;
        }
        MethodElementReturnTypeGoal methodGoal = new MethodElementReturnTypeGoal(context, types, method, argNames, offset);
        evaluatedType = typeInferencer.evaluateType(methodGoal);
        modelElements = evaluatedType instanceof PHPThisClassType && ((PHPThisClassType)evaluatedType).getType() != null ? new IType[]{((PHPThisClassType)evaluatedType).getType()} : PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)context, offset);
        if (modelElements != null) {
            return modelElements;
        }
        return EMPTY_TYPES;
    }

    public static IType getSelfClassData(ISourceModule sourceModule, int offset) {
        IType type = PHPModelUtils.getCurrentType(sourceModule, offset);
        IMethod method = PHPModelUtils.getCurrentMethod(sourceModule, offset);
        if (type != null && method != null) {
            try {
                int flags = type.getFlags();
                if (!(PHPFlags.isAbstract((int)flags) || PHPFlags.isInterface((int)flags) || PHPFlags.isInterface((int)flags))) {
                    return type;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
        return null;
    }

    public static IType[] getTypesFor(ISourceModule sourceModule, @NonNull TextSequence statementText, int endPosition, int offset) {
        return CodeAssistUtils.getTypesFor(sourceModule, statementText, endPosition, offset, null);
    }

    protected static IType[] getTypesFor(ISourceModule sourceModule, @NonNull TextSequence statementText, int endPosition, int offset, String triggerText) {
        int closeBracketIndex;
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition);
        boolean isClassTrigger = false;
        if (endPosition < 2) {
            return EMPTY_TYPES;
        }
        int propertyEndPosition = endPosition;
        if (triggerText == null) {
            triggerText = statementText.subSequence(endPosition - 2, endPosition).toString();
            propertyEndPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition - triggerText.length());
        }
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (triggerText.equals(PAAMAYIM_NEKUDOTAIM)) {
                isClassTrigger = true;
            } else {
                return EMPTY_TYPES;
            }
        }
        int lastObjectOperator = PHPTextSequenceUtilities.getPreviousTriggerIndex(statementText, propertyEndPosition);
        String text = statementText.subSequence(0, propertyEndPosition).toString();
        if (lastObjectOperator == -1 || text.indexOf(62) >= 0 && text.indexOf("=>") != text.indexOf(62) - 1 && text.indexOf(OBJECT_FUNCTIONS_TRIGGER) < 0) {
            return CodeAssistUtils.innerGetClassName(sourceModule, statementText, propertyEndPosition, isClassTrigger, offset);
        }
        int propertyStartPosition = PHPTextSequenceUtilities.readForwardSpaces(statementText, lastObjectOperator + triggerText.length());
        String propertyName = statementText.subSequence(propertyStartPosition, propertyEndPosition).toString();
        IType[] types = CodeAssistUtils.getTypesFor(sourceModule, statementText, propertyStartPosition, offset);
        int bracketIndex = propertyName.indexOf(40);
        if (bracketIndex == -1) {
            return CodeAssistUtils.getVariableType(types, propertyName, offset);
        }
        boolean arrayReference = false;
        PHPVersion version = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
        if (propertyName.endsWith("]") && version.isGreaterThan(PHPVersion.PHP5_3) && (closeBracketIndex = propertyName.lastIndexOf(41)) >= 0 && propertyName.indexOf(91, closeBracketIndex) > closeBracketIndex) {
            arrayReference = true;
        }
        String functionName = propertyName.substring(0, bracketIndex).trim();
        String[] argNames = PHPTextSequenceUtilities.getArgNames(version, propertyName.substring(bracketIndex));
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType[] returnTypes = null;
        returnTypes = arrayReference ? CodeAssistUtils.getFunctionArrayReturnType(types, functionName, 32, sourceModule, offset, argNames) : CodeAssistUtils.getFunctionReturnType(types, functionName, 32, sourceModule, offset, argNames);
        if (returnTypes != null) {
            result.addAll(Arrays.asList(returnTypes));
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] getTraitsFor(ISourceModule sourceModule, @NonNull TextSequence statementText, int endPosition, int offset) {
        String className;
        PHPVersion phpVersion = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
        if (phpVersion.isLessThan(PHPVersion.PHP5_4)) {
            return EMPTY_TYPES;
        }
        if ((endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition)) < 2) {
            return EMPTY_TYPES;
        }
        String triggerText = statementText.subSequence(endPosition - 2, endPosition).toString();
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER) && !triggerText.equals(PAAMAYIM_NEKUDOTAIM)) {
            return EMPTY_TYPES;
        }
        int propertyEndPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition - triggerText.length());
        int classNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, statementText, propertyEndPosition, true);
        String string = className = classNameStart < 0 ? "" : statementText.subSequence(classNameStart, propertyEndPosition).toString();
        if (className.length() > 0) {
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            FileContext context = new FileContext(sourceModule, moduleDeclaration, offset);
            PHPClassType type = PHPClassType.fromTraitName(className, sourceModule, offset);
            IType[] modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)type, (ISourceModuleContext)context, offset);
            if (modelElements != null) {
                return modelElements;
            }
        }
        return EMPTY_TYPES;
    }

    private static IType[] getFunctionArrayReturnType(IType[] types, String method, int mask, ISourceModule sourceModule, int offset, String[] argNames) {
        MethodElementReturnTypeGoal methodGoal;
        Object[] tmpArray;
        IEvaluatedType evaluatedType;
        boolean usePhpDoc;
        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, offset);
        if (context == null) {
            context = new BasicContext(sourceModule, moduleDeclaration);
            Logger.log(2, "Context is null!");
        }
        boolean bl = usePhpDoc = (mask & 0x20) != 0;
        if (usePhpDoc) {
            PHPDocMethodReturnTypeGoal phpDocGoal = new PHPDocMethodReturnTypeGoal(context, types, method, argNames, offset);
            evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal);
            ArrayList possibleTypes = null;
            if (!PHPTypeInferenceUtils.isSimple(evaluatedType)) {
                if (evaluatedType instanceof MultiTypeType) {
                    possibleTypes = ((MultiTypeType)evaluatedType).getTypes();
                } else if (evaluatedType instanceof AmbiguousType) {
                    possibleTypes = new ArrayList();
                    IEvaluatedType[] iEvaluatedTypeArray = ((AmbiguousType)evaluatedType).getPossibleTypes();
                    int n = iEvaluatedTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEvaluatedType pType = iEvaluatedTypeArray[n2];
                        if (pType instanceof MultiTypeType) {
                            possibleTypes.addAll(((MultiTypeType)pType).getTypes());
                        }
                        ++n2;
                    }
                }
                if (possibleTypes != null && possibleTypes.size() > 0) {
                    LinkedList<Object> tmpList = new LinkedList<Object>();
                    for (IEvaluatedType possibleType : possibleTypes) {
                        tmpArray = PHPTypeInferenceUtils.getModelElements(possibleType, (ISourceModuleContext)context, offset, null);
                        if (!ArrayUtils.isNotEmpty((Object[])tmpArray)) continue;
                        tmpList.addAll(Arrays.asList(tmpArray));
                    }
                    return tmpList.toArray(new IType[tmpList.size()]);
                }
            }
        }
        if ((evaluatedType = typeInferencer.evaluateType(methodGoal = new MethodElementReturnTypeGoal(context, types, method, argNames, offset))) instanceof MultiTypeType) {
            LinkedList<IType> tmpList = new LinkedList<IType>();
            List possibleTypes = ((MultiTypeType)evaluatedType).getTypes();
            for (IEvaluatedType possibleType : possibleTypes) {
                tmpArray = PHPTypeInferenceUtils.getModelElements(possibleType, (ISourceModuleContext)context, offset, null);
                if (tmpArray == null) continue;
                tmpList.addAll(Arrays.asList(tmpArray));
            }
            return tmpList.toArray(new IType[tmpList.size()]);
        }
        return EMPTY_TYPES;
    }

    private static IType[] innerGetClassName(ISourceModule sourceModule, @NonNull TextSequence statementText, int propertyEndPosition, boolean isClassTriger, int offset) {
        int closeBracketIndex;
        String testedVar;
        String className;
        PHPVersion phpVersion = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
        int classNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, statementText, propertyEndPosition, true);
        String string = className = classNameStart < 0 ? "" : statementText.subSequence(classNameStart, propertyEndPosition).toString();
        if (isClassTriger && className != null && className.length() != 0) {
            IType classData;
            String comparable;
            String string2 = comparable = PHPVersion.PHP5_4.isLessThan(phpVersion) ? className.toLowerCase() : className;
            if (("self".equals(comparable) || "parent".equals(comparable) || phpVersion.isGreaterThan(PHPVersion.PHP5) && "static".equals(comparable)) && (classData = PHPModelUtils.getCurrentType(sourceModule, offset - className.length() - 2)) != null) {
                return new IType[]{classData};
            }
            if (className.length() > 0) {
                if (className.startsWith(DOLLAR) && phpVersion.isGreaterThan(PHPVersion.PHP5)) {
                    int statementStart = statementText.getOriginalOffset(classNameStart);
                    return CodeAssistUtils.getVariableType(sourceModule, className, statementStart);
                }
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
                FileContext context = new FileContext(sourceModule, moduleDeclaration, offset);
                PHPClassType type = PHPClassType.fromTypeName(className, sourceModule, offset);
                IType[] modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)type, (ISourceModuleContext)context, offset);
                if (modelElements != null) {
                    return modelElements;
                }
                return EMPTY_TYPES;
            }
        }
        if (className != null && className.length() == 0 && (testedVar = statementText.subSequence(0, propertyEndPosition).toString().trim()) != null && testedVar.length() != 0) {
            Matcher m = globalPattern.matcher(testedVar);
            if (m.matches()) {
                String quotedVarName = testedVar.substring(testedVar.indexOf(91) + 1, testedVar.indexOf(93)).trim();
                className = DOLLAR + quotedVarName.substring(1, quotedVarName.length() - 1);
            } else if (testedVar.endsWith("}")) {
                className = testedVar;
            } else if (testedVar.endsWith("]")) {
                if (statementText.toString().lastIndexOf(91) > 0) {
                    int end = statementText.toString().lastIndexOf(91);
                    int classNameStart1 = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, statementText, end, true);
                    String string3 = className = classNameStart1 < 0 ? "" : statementText.subSequence(classNameStart1, end).toString();
                    if (className.length() > 0 && className.charAt(0) == '$') {
                        int statementStart = statementText.getOriginalOffset(classNameStart);
                        return CodeAssistUtils.getArrayVariableType(sourceModule, className, statementStart);
                    }
                }
                className = testedVar;
            }
        }
        if (className != null && className.length() > 0 && className.charAt(0) == '$') {
            int statementStart = statementText.getOriginalOffset(classNameStart);
            return CodeAssistUtils.getVariableType(sourceModule, className, statementStart);
        }
        boolean arrayReference = false;
        if (propertyEndPosition > 0 && statementText.charAt(propertyEndPosition - 1) == ']' && phpVersion.isGreaterThan(PHPVersion.PHP5_3) && (closeBracketIndex = statementText.toString().lastIndexOf(41)) >= 0 && statementText.toString().indexOf(91, closeBracketIndex) > closeBracketIndex) {
            propertyEndPosition = closeBracketIndex + 1;
            arrayReference = true;
        }
        if (propertyEndPosition > 0 && statementText.charAt(propertyEndPosition - 1) == ')') {
            String functionName;
            int functionNameEnd = PHPModelUtils.getFunctionNameEndOffset(statementText, propertyEndPosition - 1);
            int functionNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, statementText, functionNameEnd, false);
            String string4 = functionName = functionNameStart < 0 ? "" : statementText.subSequence(functionNameStart, functionNameEnd).toString().trim();
            if (CodeAssistUtils.isKeyword(functionName)) {
                functionName = "";
                functionNameStart = functionNameEnd = PHPTextSequenceUtilities.readForwardSpaces(statementText, functionNameEnd);
            }
            LinkedHashSet<Object> returnTypes = new LinkedHashSet<Object>();
            if (functionNameStart == functionNameEnd && statementText.charAt(functionNameStart) == '(' && propertyEndPosition - 1 > functionNameStart + 1 && phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
                TextSequence newClassStatementText = statementText.subTextSequence(functionNameStart + 1, propertyEndPosition - 1);
                if (newClassStatementText.length() < 4 || !newClassStatementText.subSequence(0, 3).toString().equals(NEW)) {
                    int innerStart = PHPTextSequenceUtilities.readForwardSpaces(newClassStatementText, 0);
                    if (newClassStatementText.charAt(innerStart) == '(' || phpVersion.isGreaterThan(PHPVersion.PHP5_6)) {
                        return CodeAssistUtils.getTypesFor(sourceModule, newClassStatementText, newClassStatementText.length(), newClassStatementText.length(), isClassTriger ? PAAMAYIM_NEKUDOTAIM : OBJECT_FUNCTIONS_TRIGGER);
                    }
                    return EMPTY_TYPES;
                }
                String newClassName = PHPModelUtils.getClassNameForNewStatement(newClassStatementText, phpVersion);
                try {
                    return PHPModelUtils.getTypes(newClassName, sourceModule, offset, null, null);
                }
                catch (ModelException e) {
                    if (DLTKCore.DEBUG) {
                        Logger.logException(e);
                    }
                }
            } else {
                String[] argNames = PHPTextSequenceUtilities.getArgNames(phpVersion, statementText.subSequence(functionNameEnd, propertyEndPosition - 1));
                if (arrayReference) {
                    IType[] types = CodeAssistUtils.getFunctionArrayReturnType(null, functionName, 32, sourceModule, offset, argNames);
                    if (types != null) {
                        returnTypes.addAll(Arrays.asList(types));
                    }
                } else {
                    Object[] types = CodeAssistUtils.getFunctionReturnType(null, functionName, 32, sourceModule, offset, argNames);
                    if (ArrayUtils.isNotEmpty((Object[])types)) {
                        returnTypes.addAll(Arrays.asList(types));
                    } else {
                        IType namespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                        Map<String, UsePart> useParts = PHPModelUtils.getAliasToNSMap(functionName, moduleDeclaration, offset, namespace, true);
                        if (useParts.containsKey(functionName)) {
                            String name = useParts.get(functionName).getNamespace().getFullyQualifiedName();
                            name = String.valueOf('\\') + name;
                            types = CodeAssistUtils.getFunctionReturnType(null, name, 32, sourceModule, offset, argNames);
                            if (types != null) {
                                returnTypes.addAll(Arrays.asList(types));
                            }
                        }
                    }
                }
            }
            return returnTypes.toArray(new IType[returnTypes.size()]);
        }
        return EMPTY_TYPES;
    }

    private static boolean isKeyword(String functionName) {
        String[] stringArray = KEYWORD_FUNCTION_NAMES;
        int n = KEYWORD_FUNCTION_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (k.equalsIgnoreCase(functionName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isClassFunctionCall(ISourceModule sourceModule, IType[] className, String functionName) {
        IType[] iTypeArray = className;
        int n = className.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                IMethod[] classMethod = PHPModelUtils.getTypeHierarchyMethod(type, functionName, true, null);
                if (classMethod != null) {
                    return true;
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return false;
    }

    public static <T extends IModelElement> List<T> removeDuplicatedElements(T[] elements) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<String> names = new HashSet<String>();
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (!names.contains(element.getElementName())) {
                result.add(element);
                names.add(element.getElementName());
            }
            ++n2;
        }
        return result;
    }
}

