/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.Visitor;

public class Scalar
extends VariableBase {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_SYSTEM = 4;
    public static final int TYPE_BIN = 5;
    private String stringValue;
    private int scalarType;
    public static final SimplePropertyDescriptor VALUE_PROPERTY = new SimplePropertyDescriptor(Scalar.class, "stringValue", String.class, true);
    public static final SimplePropertyDescriptor TYPE_PROPERTY = new SimplePropertyDescriptor(Scalar.class, "scalarType", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<SimplePropertyDescriptor> propertyList = new ArrayList<SimplePropertyDescriptor>(3);
        propertyList.add(VALUE_PROPERTY);
        propertyList.add(TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public Scalar(int start, int end, AST ast, String value, int type) {
        super(start, end, ast);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.setScalarType(type);
        this.setStringValue(value);
    }

    public Scalar(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Scalar");
        this.appendInterval(buffer);
        buffer.append(" type='").append(Scalar.getType(this.scalarType)).append("'");
        if (this.stringValue != null) {
            buffer.append(" value='").append(Scalar.getXmlStringValue(this.stringValue)).append("'");
        }
        buffer.append("/>");
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "unknown";
            }
            case 4: {
                return "system";
            }
            case 5: {
                return "bin";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getType() {
        return 51;
    }

    public int getScalarType() {
        return this.scalarType;
    }

    public final void setScalarType(int type) {
        if (Scalar.getType(type) == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(TYPE_PROPERTY);
        this.scalarType = type;
        this.postValueChange(TYPE_PROPERTY);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == TYPE_PROPERTY) {
            if (get) {
                return this.getScalarType();
            }
            this.setScalarType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public final void setStringValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(VALUE_PROPERTY);
        this.stringValue = value;
        this.postValueChange(VALUE_PROPERTY);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == VALUE_PROPERTY) {
            if (get) {
                return this.getStringValue();
            }
            this.setStringValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Scalar result = new Scalar(this.getStart(), this.getEnd(), target, this.getStringValue(), this.getScalarType());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        return super.internalGetSetChildProperty(property, get, child);
    }
}

