/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.converter.MultiUMLReferenceDisplayConverter;
import org.eclipse.papyrus.uml.nattable.editor.MultiReferenceCellEditor;
import org.eclipse.uml2.uml.UMLPackage;

public class MultiUMLReferenceCellEditorConfiguration
implements ICellAxisConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.MultiUMLReferenceCellEditorConfiguration.MultiEditor";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a Text Editor for a multi UML reference value";
    }

    public boolean handles(Table table, Object axisElement) {
        EStructuralFeature feature;
        boolean result = false;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        if (object instanceof EStructuralFeature && (feature = (EStructuralFeature)object).isMany()) {
            EClassifier etype = feature.getEType();
            result = EMFHelper.isSuperType((EClassifier)UMLPackage.eINSTANCE.getElement(), (EClassifier)etype);
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TextPainter(), "NORMAL", configLabel);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new MultiReferenceCellEditor(axis, modelManager.getTableAxisElementProvider()), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new MultiUMLReferenceDisplayConverter(), "EDIT", configLabel);
    }
}

