/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.core.resource.PapyrusProjectScope;
import org.eclipse.papyrus.infra.ui.preferences.PapyrusScopedPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.internationalization.common";
    public static final String INTERNATIONALIZATION_NODE_LABEL = "internationalization";
    private static Activator plugin;
    public static LogHelper log;
    private List<IPreferenceStore> preferencesStore = new ArrayList<IPreferenceStore>(0);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public IPreferenceStore getInternationalizationPreferenceStore(IProject project, String papyrusProjectName) {
        PapyrusScopedPreferenceStore result = null;
        PapyrusProjectScope scope = new PapyrusProjectScope(project, papyrusProjectName);
        if (!this.preferencesStore.isEmpty()) {
            IEclipsePreferences scopePreferenceNode = scope.getNode(INTERNATIONALIZATION_NODE_LABEL);
            Iterator<IPreferenceStore> preferenceStoreIterator = this.preferencesStore.iterator();
            while (preferenceStoreIterator.hasNext() && result == null) {
                IPreferenceStore preferenceStore = preferenceStoreIterator.next();
                if (!(preferenceStore instanceof PapyrusScopedPreferenceStore)) continue;
                IEclipsePreferences[] preferenceNodes = ((PapyrusScopedPreferenceStore)preferenceStore).getPreferenceNodes(false);
                int index = 0;
                while (index < preferenceNodes.length && result == null) {
                    if (preferenceNodes[index].equals(scopePreferenceNode)) {
                        result = preferenceStore;
                    }
                    ++index;
                }
            }
        }
        if (result == null) {
            result = new PapyrusScopedPreferenceStore((IScopeContext)scope, INTERNATIONALIZATION_NODE_LABEL);
            this.preferencesStore.add((IPreferenceStore)result);
        }
        return result;
    }

    public IPreferenceStore getInternationalizationPreferenceStore() {
        if (this.preferencesStore.isEmpty()) {
            this.preferencesStore.add((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundle().getSymbolicName()));
        }
        return this.preferencesStore.get(0);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

