/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmWritableBoundClass;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public class AddThreadNotificationAdapter
extends ClassVisitor {
    protected static final String THREAD_DESC = "L" + ClassNames.THREAD_SLASH + ";";
    protected static final String VOID_DESC = "()V";
    protected static final String RUN = "run";
    protected static final String RUN_DESC = "()V";
    protected static final String CURRENT_THREAD = "currentThread";
    protected static final String CURRENT_THREAD_DESC = "()" + THREAD_DESC;
    protected static final String NEW_THREAD_STARTED = "newThreadStarted";
    protected static final String NEW_THREAD_STARTED_DESC = "(Z" + THREAD_DESC + ")Z";
    protected static final String THREAD_ENDED = "threadEnded";
    protected static final String THREAD_ENDED_DESC = "()V";
    protected static final String INIT = "<init>";
    protected static final String CREATION_THREAD = "_OT$creationThread";
    private AsmBoundClass clazz;

    public AddThreadNotificationAdapter(ClassVisitor cv, AsmBoundClass clazz) {
        super(327680, cv);
        this.clazz = clazz;
    }

    public void visitEnd() {
        this.cv.visitField(2, CREATION_THREAD, THREAD_DESC, null, null);
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        if (INIT.equals(methodName)) {
            final MethodVisitor methodVisitor = this.cv.visitMethod(access, methodName, desc, null, null);
            return new AdviceAdapter(this.api, methodVisitor, access, methodName, desc){

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
                    super.visitMethodInsn(opcode, owner, name, desc, itfc);
                    if (opcode == 183 && AddThreadNotificationAdapter.INIT.equals(name) && owner.equals(AddThreadNotificationAdapter.this.clazz.getInternalSuperClassName())) {
                        methodVisitor.visitIntInsn(25, 0);
                        methodVisitor.visitMethodInsn(184, ClassNames.THREAD_SLASH, AddThreadNotificationAdapter.CURRENT_THREAD, CURRENT_THREAD_DESC, false);
                        methodVisitor.visitFieldInsn(181, AddThreadNotificationAdapter.this.clazz.getInternalName(), AddThreadNotificationAdapter.CREATION_THREAD, THREAD_DESC);
                    }
                }
            };
        }
        if (RUN.equals(methodName) && "()V".equals(desc)) {
            final MethodVisitor methodVisitor = this.cv.visitMethod(access, methodName, desc, null, null);
            return new AdviceAdapter(this.api, methodVisitor, access, methodName, desc){
                Label start;
                Label end;
                int isThreadStartIdx;
                {
                    super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                    this.start = new Label();
                    this.end = new Label();
                }

                protected void onMethodEnter() {
                    methodVisitor.visitLabel(this.start);
                    this.isThreadStartIdx = this.newLocal(Type.BOOLEAN_TYPE);
                    methodVisitor.visitLocalVariable("_OT$isThreadStart", "Z", null, this.start, this.end, this.isThreadStartIdx);
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitIntInsn(25, 0);
                    methodVisitor.visitFieldInsn(180, AddThreadNotificationAdapter.this.clazz.getInternalName(), AddThreadNotificationAdapter.CREATION_THREAD, THREAD_DESC);
                    methodVisitor.visitMethodInsn(184, ClassNames.TEAM_THREAD_MANAGER_SLASH, AddThreadNotificationAdapter.NEW_THREAD_STARTED, NEW_THREAD_STARTED_DESC, false);
                    methodVisitor.visitIntInsn(54, this.isThreadStartIdx);
                    methodVisitor.visitIntInsn(25, 0);
                    methodVisitor.visitInsn(1);
                    methodVisitor.visitFieldInsn(181, AddThreadNotificationAdapter.this.clazz.getInternalName(), AddThreadNotificationAdapter.CREATION_THREAD, THREAD_DESC);
                }

                protected void onMethodExit(int opcode) {
                    this.insertThreadEndedNotification();
                }

                public void endMethod() {
                    methodVisitor.visitLabel(this.end);
                    Label handler = new Label();
                    methodVisitor.visitLabel(handler);
                    this.insertThreadEndedNotification();
                    methodVisitor.visitInsn(191);
                    methodVisitor.visitTryCatchBlock(this.start, this.end, handler, ClassNames.THROWABLE_SLASH);
                    methodVisitor.visitMaxs(0, 0);
                }

                void insertThreadEndedNotification() {
                    Label skip = new Label();
                    methodVisitor.visitIntInsn(21, this.isThreadStartIdx);
                    methodVisitor.visitJumpInsn(153, skip);
                    methodVisitor.visitMethodInsn(184, ClassNames.TEAM_THREAD_MANAGER_SLASH, AddThreadNotificationAdapter.THREAD_ENDED, "()V", false);
                    methodVisitor.visitLabel(skip);
                }
            };
        }
        return null;
    }

    public static boolean shouldNotify(AsmWritableBoundClass clazz) {
        String[] interfaceNames = clazz.getSuperInterfaceNames();
        if (interfaceNames != null) {
            int i = 0;
            while (i < interfaceNames.length) {
                if (ClassNames.RUNNABLE_SLASH.equals(interfaceNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return ClassNames.THREAD_SLASH.equals(clazz.getInternalSuperClassName());
    }
}

