/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.util.atl.core.internal.AtlLaunchHelper;

public class TranslateJavaModelToKdm {
    private static final String KDM_MM_URI = "http://www.eclipse.org/MoDisco/kdm/action";
    private static final String JAVA_MM_URI = "http://www.eclipse.org/MoDisco/Java/0.2.incubation/java";
    private String pathToTransformation;
    private static final String PATH_TO_TRANSFORMATION_DEFAULT = "resources/transformations/javaToKdm.asm";

    public void setPathToTransformation(String newPathToTransformation) {
        this.pathToTransformation = newPathToTransformation;
    }

    public String getPathToTransformation() {
        return this.pathToTransformation;
    }

    public Resource getKDMModelFromJavaModelWithCustomTransformation(URI javaSourceModelUri, Resource javaModel, URI kdmTargetModelUri) throws IOException {
        URL url;
        if (this.getPathToTransformation() == null || this.getPathToTransformation().length() == 0) {
            this.setPathToTransformation(PATH_TO_TRANSFORMATION_DEFAULT);
        }
        if ((url = TranslateJavaModelToKdm.class.getResource(this.getPathToTransformation())) == null) {
            try {
                url = new URL(this.getPathToTransformation());
            }
            catch (MalformedURLException e) {
                MoDiscoLogger.logError((Throwable)e, (String)("wrong URL: " + this.getPathToTransformation()), (Plugin)JavaActivator.getDefault());
            }
            if (url == null) {
                url = TranslateJavaModelToKdm.class.getResource(PATH_TO_TRANSFORMATION_DEFAULT);
            }
        }
        URL transformation = url;
        return TranslateJavaModelToKdm.getKDMModelFromJavaModelWithCustomTransformation(javaSourceModelUri, javaModel, transformation, kdmTargetModelUri);
    }

    public static Resource getKDMModelFromJavaModelWithCustomTransformation(URI javaSourceModelUri, Resource javaModel, URL transformation, URI kdmTargetModelUri) throws IOException {
        URI localKdmTargetModelUri = kdmTargetModelUri;
        if (kdmTargetModelUri == null) {
            localKdmTargetModelUri = javaSourceModelUri.trimFileExtension().appendFileExtension("kdm");
        }
        AtlLaunchHelper.ModelInfo inputModel = new AtlLaunchHelper.ModelInfo("IN", javaSourceModelUri, javaModel, "java", URI.createURI((String)JAVA_MM_URI));
        AtlLaunchHelper.ModelInfo outputModel = new AtlLaunchHelper.ModelInfo("OUT", localKdmTargetModelUri, null, "kdm", URI.createURI((String)KDM_MM_URI));
        AtlLaunchHelper atlHelper = new AtlLaunchHelper();
        Resource result = atlHelper.runTransformation(transformation, inputModel, outputModel);
        return result;
    }
}

