/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.jdt.docker.launcher.ContainerVMInstall;
import org.eclipse.linuxtools.jdt.docker.launcher.ContainerVMRunner;
import org.eclipse.linuxtools.jdt.docker.launcher.ImageQuery;
import org.eclipse.linuxtools.jdt.docker.launcher.Messages;
import org.eclipse.linuxtools.jdt.docker.launcher.UnixFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JavaAppInContainerLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        final String connectionURI = configuration.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.connection.uri", null);
        final String imageID = configuration.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.image.id", null);
        List extraDirs = configuration.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.directories", Arrays.asList(new String[0]));
        try {
            IDockerImage img;
            DockerConnection conn = (DockerConnection)DockerConnectionManager.getInstance().getConnectionByUri(connectionURI);
            if (conn == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.JavaAppInContainerLaunchDelegate_connection_not_found_title, (String)Messages.bind((String)Messages.JavaAppInContainerLaunchDelegate_connection_not_found_text, (Object)connectionURI));
                    }
                });
                return;
            }
            if (!conn.isOpen()) {
                try {
                    conn.open(false);
                }
                catch (DockerException dockerException) {
                    // empty catch block
                }
                if (!conn.isOpen()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.JavaAppInContainerLaunchDelegate_connection_not_active_title, (String)Messages.bind((String)Messages.JavaAppInContainerLaunchDelegate_connection_not_active_text, (Object)connectionURI));
                        }
                    });
                    return;
                }
            }
            if ((img = conn.getImage(imageID)) == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.JavaAppInContainerLaunchDelegate_image_not_found_title, (String)Messages.bind((String)Messages.JavaAppInContainerLaunchDelegate_image_not_found_text, (Object)imageID));
                    }
                });
                return;
            }
            int port = "debug".equals(mode) ? (int)(64510.0 * Math.random()) + 1025 : -1;
            monitor.subTask(Messages.JavaAppInContainerLaunchDelegate_Verifying_launch_attributes____1);
            String mainTypeName = this.verifyMainTypeName(configuration);
            ContainerVMInstall vm = new ContainerVMInstall(configuration, img, port);
            final ContainerVMRunner runner = new ContainerVMRunner(vm);
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            runner.setAdditionalDirectories(extraDirs);
            String[] envp = this.getEnvironment(configuration);
            String pgmArgs = this.getProgramArguments(configuration);
            String vmArgs = this.getVMArguments(configuration);
            ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
            Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
            String[] classpath = this.getClasspath(configuration);
            if ("win32".equals(Platform.getOS())) {
                int i = 0;
                while (i < classpath.length) {
                    classpath[i] = UnixFile.convertDOSPathToUnixPath(classpath[i]);
                    ++i;
                }
            }
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(envp);
            ArrayList<String> finalVMArgs = new ArrayList<String>(Arrays.asList(execArgs.getVMArgumentsArray()));
            if ("debug".equals(mode)) {
                double version = this.getJavaVersion(conn, img);
                if (version < 1.5) {
                    finalVMArgs.add("-Xdebug");
                    finalVMArgs.add("-Xnoagent");
                }
                if (version < 1.4) {
                    finalVMArgs.add("-Djava.compiler=NONE");
                }
                if (version < 1.5) {
                    finalVMArgs.add("-Xrunjdwp:transport=dt_socket,server=y,address=" + port);
                } else {
                    finalVMArgs.add("-agentlib:jdwp=transport=dt_socket,server=y,address=" + port);
                }
            }
            runConfig.setVMArguments(finalVMArgs.toArray(new String[0]));
            runConfig.setWorkingDirectory(workingDirName);
            runConfig.setVMSpecificAttributesMap(vmAttributesMap);
            runConfig.setBootClassPath(this.getBootpath(configuration));
            if (monitor.isCanceled()) {
                return;
            }
            this.prepareStopInMain(configuration);
            monitor.worked(1);
            monitor.subTask(Messages.JavaAppInContainerLaunchDelegate_Creating_source_locator____2);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if ("debug".equals(mode)) {
                while (runner.getIPAddress() == null || !runner.isListening()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException version) {
                        // empty catch block
                    }
                }
                IDockerContainerInfo info = runner.getContainerInfo();
                String configName = info.name().startsWith("/") ? info.name().substring(1) : info.name();
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
                ILaunchConfigurationWorkingCopy cfgForAttach = type.newInstance(null, configName);
                ILaunchConfigurationWorkingCopy wc = cfgForAttach.getWorkingCopy();
                String ip = runner.getIPAddress();
                if (!this.isListening(ip, port)) {
                    if (conn.getSettings() instanceof TCPConnectionSettings) {
                        ip = ((TCPConnectionSettings)conn.getSettings()).getAddr();
                        if (!this.isListening(ip, port) && !this.isListening(ip = this.getIPAddressListening(port), port)) {
                            ip = null;
                        }
                    } else {
                        ip = null;
                    }
                }
                if (ip == null) {
                    final String imageName = (String)conn.getImage(imageID).repoTags().get(0);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.JavaAppInContainerLaunchDelegate_session_unreachable_title, (String)Messages.bind((String)Messages.JavaAppInContainerLaunchDelegate_session_unreachable_text, (Object[])new Object[]{imageName, imageID, runner.getIPAddress()}));
                        }
                    });
                    return;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("hostname", ip);
                map.put("port", String.valueOf(port));
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, map);
                String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
                wc.doSave();
                DebugUITools.launch((ILaunchConfiguration)cfgForAttach, (String)"debug");
            }
        }
        finally {
            monitor.done();
        }
    }

    private double getJavaVersion(DockerConnection conn, IDockerImage img) {
        ImageQuery q = new ImageQuery(conn, img.id());
        double res = q.getJavaVersion();
        q.destroy();
        return res;
    }

    private boolean isListening(String addr, int port) {
        block13: {
            Throwable throwable = null;
            Object var4_6 = null;
            Socket s = new Socket();
            try {
                InetSocketAddress host = addr != null ? new InetSocketAddress(addr, port) : new InetSocketAddress(InetAddress.getByName(null), port);
                s.connect(host, 1000);
                if (s == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (s != null) {
                        s.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }
            s.close();
        }
        return true;
    }

    private String getIPAddressListening(int port) {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp()) continue;
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!(addr instanceof Inet4Address) || !this.isListening(addr.getHostAddress(), port)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }
}

