/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.support.lua51.internal.interpreter;

import com.naef.jnlua.LuaState;
import java.util.ArrayList;

public class JNLua51Launcher {
    protected JNLua51Launcher() {
    }

    public void run(String[] args) {
        System.loadLibrary("lua5.1");
        final LuaState l = new LuaState();
        boolean showVersion = false;
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        String scriptToLoad = null;
        ArrayList<String> scriptArg = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ("-i".equals(arg)) {
                System.out.println("Warning : -i option is not supported by JNLua Interpreter.");
            } else if ("-v".equals(arg)) {
                showVersion = true;
            } else if ("-l".equals(arg)) {
                if (++i < args.length) {
                    final String library = args[i];
                    actions.add(new Runnable(){

                        @Override
                        public void run() {
                            l.load("require ([[" + library + "]])", "-l option");
                            l.call(0, 0);
                        }
                    });
                }
            } else if ("-e".equals(arg)) {
                if (++i < args.length) {
                    final String code = args[i];
                    actions.add(new Runnable(){

                        @Override
                        public void run() {
                            l.load(code, "-e option");
                            l.call(0, 0);
                        }
                    });
                }
            } else {
                scriptToLoad = args[i];
                ++i;
                while (i < args.length) {
                    scriptArg.add(args[i]);
                    ++i;
                }
            }
            ++i;
        }
        try {
            this.loadlibraries(l);
            if (showVersion) {
                l.getGlobal("_VERSION");
                String luaVersion = l.toString(1);
                String jnluaVersion = "0.9";
                l.pop(1);
                System.err.println(String.valueOf(luaVersion) + " on JNLua " + (String)jnluaVersion);
            }
            for (Runnable action : actions) {
                action.run();
            }
            l.newTable(args.length + 1, 0);
            int interpreterIndex = scriptArg.size() - args.length;
            l.pushString("jnlua");
            l.rawSet(-2, interpreterIndex);
            int i2 = 0;
            while (i2 < args.length) {
                l.pushString(args[i2]);
                l.rawSet(-2, interpreterIndex + i2 + 1);
                ++i2;
            }
            l.setGlobal("arg");
            if (scriptToLoad != null) {
                l.load("assert(loadfile([[" + scriptToLoad + "]]))(unpack(arg,1,#arg))", "main");
                l.call(0, 0);
            }
        }
        finally {
            l.close();
        }
    }

    protected void loadlibraries(LuaState l) {
        l.openLibs();
    }

    public static void main(String[] args) {
        JNLua51Launcher jnLuaLauncher = new JNLua51Launcher();
        jnLuaLauncher.run(args);
    }
}

