/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal.attach;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.ldt.debug.core.internal.Activator;
import org.eclipse.ldt.debug.core.internal.LuaAbsoluteFileURIBreakpointPathMapper;
import org.eclipse.ldt.debug.core.internal.LuaDebugTarget;
import org.eclipse.ldt.debug.core.internal.LuaModuleURIBreakpointPathMapper;
import org.eclipse.ldt.debug.core.internal.attach.LuaAttachBreakpointPathMapper;

public abstract class LuaAttachDebugTarget
extends LuaDebugTarget {
    public LuaAttachDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process) {
        super(modelId, dbgpService, sessionId, launch, process);
        if ("module".equals(this.getSourceMappingType())) {
            this.setScriptDebugThreadConfigurator(new IScriptDebugThreadConfigurator(){

                public void initializeBreakpoints(IScriptThread thread, IProgressMonitor monitor) {
                }

                public void configureThread(DbgpDebugger engine, ScriptThread scriptThread) {
                    String urimode = "module";
                    try {
                        scriptThread.getDbgpSession().getCoreCommands().setFeature("uri", urimode);
                    }
                    catch (DbgpException e) {
                        Activator.logWarning("Unable to set feature uri to " + urimode, e);
                    }
                }
            });
        }
    }

    public boolean isRemote() {
        return true;
    }

    public String toString() {
        return "Debugging engine (idekey = " + this.getSessionId() + ", port =" + DLTKDebugPlugin.getDefault().getDbgpService().getPort() + ")";
    }

    protected IScriptBreakpointPathMapper createPathMapper() {
        String mappingType = this.getSourceMappingType();
        if (mappingType.equals("module")) {
            return new LuaModuleURIBreakpointPathMapper(this.getScriptProject());
        }
        if (mappingType.equals("replace_path")) {
            return new LuaAttachBreakpointPathMapper(this.getScriptProject(), this.folder());
        }
        return new LuaAbsoluteFileURIBreakpointPathMapper();
    }

    protected abstract String folder();

    protected String getSourceMappingType() {
        return LaunchConfigurationUtils.getString((ILaunchConfiguration)this.getLaunch().getLaunchConfiguration(), (String)"source_mapping_type", (String)"local");
    }
}

