/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.model.view;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EdgeDirection implements Enumerator
{
    DEFAULT(0, "default", "default"),
    NONE(1, "none", "none"),
    IN(2, "in", "in"),
    OUT(3, "out", "out"),
    INOUT(4, "inout", "inout");

    public static final String copyright = "Copyright (c) 2005-2012  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";
    public static final int DEFAULT_VALUE = 0;
    public static final int NONE_VALUE = 1;
    public static final int IN_VALUE = 2;
    public static final int OUT_VALUE = 3;
    public static final int INOUT_VALUE = 4;
    private static final EdgeDirection[] VALUES_ARRAY;
    public static final List<EdgeDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeDirection[]{DEFAULT, NONE, IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeDirection get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return NONE;
            }
            case 2: {
                return IN;
            }
            case 3: {
                return OUT;
            }
            case 4: {
                return INOUT;
            }
        }
        return null;
    }

    private EdgeDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

