/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.providers.ISnappingLocationProvider;

public abstract class AbstractSnapTo
implements ISnapToStrategy {
    public static final double MAX_SNAPPING_DISTANCE_DEFAULT = 15.0;
    private IContentPart<? extends Node> snappedPart;
    private List<SnappingModel.SnappingLocation> xLocations = new ArrayList<SnappingModel.SnappingLocation>();
    private List<SnappingModel.SnappingLocation> yLocations = new ArrayList<SnappingModel.SnappingLocation>();

    protected Collection<? extends SnappingModel.SnappingLocation> determineHorizontalTargetLocations(IContentPart<? extends Node> rp) {
        ISnappingLocationProvider snappingLocationProvider = this.getTargetLocationProvider(rp);
        if (snappingLocationProvider == null) {
            return Collections.emptyList();
        }
        return snappingLocationProvider.getHorizontalSnappingLocations(rp);
    }

    protected Collection<? extends SnappingModel.SnappingLocation> determineVerticalTargetLocations(IContentPart<? extends Node> rp) {
        ISnappingLocationProvider snappingLocationProvider = this.getTargetLocationProvider(rp);
        if (snappingLocationProvider == null) {
            return Collections.emptyList();
        }
        return snappingLocationProvider.getVerticalSnappingLocations(rp);
    }

    @Override
    public List<SnappingModel.SnappingLocation> getHorizontalTargetLocations() {
        return this.xLocations;
    }

    @Override
    public double getMaximumSnappingDistance() {
        return 15.0;
    }

    @Override
    public IContentPart<? extends Node> getSnappedPart() {
        return this.snappedPart;
    }

    private ISnappingLocationProvider getTargetLocationProvider(IContentPart<? extends Node> part) {
        String role = this.getTargetLocationProviderRole();
        IVisualPart<Object> current = part;
        ISnappingLocationProvider slp = null;
        if (role != null) {
            while (slp == null && current != null) {
                slp = (ISnappingLocationProvider)current.getAdapter(AdapterKey.get(ISnappingLocationProvider.class, (String)role));
                current = current.getParent();
            }
        }
        return slp;
    }

    protected abstract String getTargetLocationProviderRole();

    @Override
    public List<SnappingModel.SnappingLocation> getVerticalTargetLocations() {
        return this.yLocations;
    }

    protected boolean isRelevant(IContentPart<? extends Node> part) {
        return true;
    }

    @Override
    public void setSnappedPart(IContentPart<? extends Node> snappedPart) {
        this.snappedPart = snappedPart;
        this.xLocations.clear();
        this.yLocations.clear();
        if (snappedPart != null) {
            List<IContentPart> relevantParts = PartUtils.filterParts(snappedPart.getViewer().getContentPartMap().values(), p -> p != snappedPart && p instanceof IContentPart && this.isRelevant((IContentPart)p));
            for (IContentPart rp : relevantParts) {
                this.xLocations.addAll(this.determineHorizontalTargetLocations(rp));
                this.yLocations.addAll(this.determineVerticalTargetLocations(rp));
            }
        }
    }
}

