/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.color.ColorPackage;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotColorJavaValidator;
import org.eclipse.xtext.validation.Check;

public class DotColorJavaValidator
extends AbstractDotColorJavaValidator {
    static String globalColorScheme = null;
    static boolean considerDefaultColorScheme = false;
    private final String defaultColorScheme = "x11";

    @Check
    public void checkConsistentColorSchemeAndColorName(StringColor color) {
        String localColorScheme;
        String colorScheme = null;
        if (considerDefaultColorScheme) {
            colorScheme = "x11";
        }
        if ((localColorScheme = color.getScheme()) != null && !localColorScheme.isEmpty()) {
            if (!DotColors.getColorSchemes().contains(localColorScheme.toLowerCase())) {
                this.error("'" + localColorScheme + "' is not a valid color scheme.", (EStructuralFeature)ColorPackage.Literals.STRING_COLOR__SCHEME);
                return;
            }
            colorScheme = localColorScheme;
        } else if (globalColorScheme != null) {
            colorScheme = globalColorScheme;
        }
        if (colorScheme == null) {
            return;
        }
        String colorName = color.getName();
        if (colorName != null && !colorName.isEmpty() && !DotColors.getColorNames(colorScheme.toLowerCase()).contains(colorName)) {
            this.error("The '" + colorName + "' color is not valid within the '" + colorScheme + "' color scheme.", (EStructuralFeature)ColorPackage.Literals.STRING_COLOR__SCHEME);
        }
    }
}

