/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.GridElementManager;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.CreateTableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableWidgetUtils {
    private TableWidgetUtils() {
    }

    public static NavigationTable createQueryTableInstance(List<ETypedElementResult> results, TableConfiguration tableConfiguration, EObject context, Object parameter) {
        NavigationTable queryTableInstance = TableFactory.eINSTANCE.createNavigationTable();
        queryTableInstance.getQueryResults().addAll(results);
        queryTableInstance.setTableConfiguration(tableConfiguration);
        queryTableInstance.setContext(context);
        queryTableInstance.setParameter(parameter);
        for (ETypedElementResult result : results) {
            Object resultValue = FacetUtils.getResultValue((ETypedElementResult)result);
            if (resultValue instanceof Collection) {
                Collection collection = (Collection)resultValue;
                for (Object object : collection) {
                    TableWidgetUtils.createQueryRow(queryTableInstance, result, object);
                }
                continue;
            }
            TableWidgetUtils.createQueryRow(queryTableInstance, result, resultValue);
        }
        CreateTableUtils.createColumns((Table)queryTableInstance);
        return queryTableInstance;
    }

    private static void createQueryRow(NavigationTable queryTableInstance, ETypedElementResult result, Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (!TableWidgetUtils.getElements((Table)queryTableInstance).contains(eObject)) {
                EObjectQueryRow row = TableFactory.eINSTANCE.createEObjectQueryRow();
                row.setElement(eObject);
                row.setQueryResult(result);
                queryTableInstance.getRows().add((Object)row);
            }
        } else {
            PrimitiveTypeQueryRow row = TableFactory.eINSTANCE.createPrimitiveTypeQueryRow();
            row.setElement((EObject)result);
            row.setQueryResult(result);
            row.setValue(object);
            queryTableInstance.getRows().add((Object)row);
        }
    }

    public static List<EObject> getElements(Table table) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Row row : table.getRows()) {
            result.add(row.getElement());
        }
        return result;
    }

    public static Object getValueOf(IGridElement gridElement, IFacetManager context) throws FacetManagerException {
        return GridElementManager.getValueOf(gridElement, context);
    }

    public static boolean isApplicable(IGridElement gridElement, IFacetManager context) {
        return GridElementManager.isApplicable(gridElement, context);
    }
}

