/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IFileHierarchyInfo;
import org.eclipse.dltk.core.IFileHierarchyResolver;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class HierarchyResolver {
    private HierarchyBuilder hierarchyBuilder;

    public HierarchyResolver(HierarchyBuilder hierarchy) {
        this.hierarchyBuilder = hierarchy;
    }

    public void resolve(boolean computeSubtypes) throws CoreException {
        IType focusType = this.hierarchyBuilder.getType();
        this.hierarchyBuilder.hierarchy.initialize(0);
        if (computeSubtypes) {
            this.computeSubtypes(focusType);
        }
        this.computeSupertypes(focusType);
    }

    private IType[] findTypes(String pattern, IDLTKSearchScope scope) throws ModelException {
        IType[] types = new ModelAccess().findTypes(pattern, pattern == null ? ISearchEngine.MatchRule.PREFIX : ISearchEngine.MatchRule.EXACT, 0, 0, scope, this.hierarchyBuilder.hierarchy.progressMonitor);
        if (types != null) {
            return types;
        }
        final LinkedList result = new LinkedList();
        final HandleFactory handleFactory = new HandleFactory();
        TypeNameRequestor typesCollector = new TypeNameRequestor(){

            @Override
            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, char[][] superTypes, String path) {
                if (superTypes != null) {
                    int i = 0;
                    while (i < superTypes.length) {
                        Openable openable;
                        ModelElement parent = openable = handleFactory.createOpenable(path, ((HierarchyResolver)HierarchyResolver.this).hierarchyBuilder.hierarchy.scope);
                        boolean binary = false;
                        if (openable instanceof ISourceModule) {
                            binary = ((ISourceModule)((Object)openable)).isBinary();
                        }
                        if (enclosingTypeNames != null) {
                            if (!binary) {
                                int j = 0;
                                while (j < enclosingTypeNames.length) {
                                    parent = new FakeType(parent, new String(enclosingTypeNames[j]));
                                    ++j;
                                }
                            } else {
                                int j = 0;
                                while (j < enclosingTypeNames.length) {
                                    if (parent instanceof ISourceModule) {
                                        parent = (ModelElement)((Object)((ISourceModule)((Object)parent)).getType(new String(enclosingTypeNames[j])));
                                    } else if (parent instanceof IType) {
                                        parent = (ModelElement)((Object)((IType)((Object)parent)).getType(new String(enclosingTypeNames[j])));
                                    }
                                    if (parent != null) {
                                        ++j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                        if (parent != null) {
                            if (binary) {
                                IType type = null;
                                if (parent instanceof ISourceModule) {
                                    type = ((ISourceModule)((Object)parent)).getType(new String(simpleTypeName));
                                } else if (parent instanceof IType) {
                                    type = ((IType)((Object)parent)).getType(new String(simpleTypeName));
                                }
                                if (type != null) {
                                    result.add(type);
                                }
                            } else {
                                FakeType type = new FakeType(parent, new String(simpleTypeName), modifiers);
                                result.add(type);
                            }
                        }
                        ++i;
                    }
                }
            }
        };
        int matchRule = 0;
        if (pattern == null) {
            pattern = "*";
            matchRule = 2;
        }
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchAllTypeNames(null, 0, pattern.toCharArray(), matchRule, 0, this.hierarchyBuilder.hierarchy.scope, typesCollector, 3, this.hierarchyBuilder.hierarchy.progressMonitor);
        return result.toArray(new IType[result.size()]);
    }

    protected void computeSubtypes(IType focusType) throws CoreException {
        IType[] types;
        HashMap<String, List<String>> superTypeToExtender = new HashMap<String, List<String>>();
        String delimiter = this.getDelimiterReplacementString(focusType);
        HashMap<String, HashSet<IType>> tmpCache = new HashMap<String, HashSet<IType>>();
        IType[] iTypeArray = types = this.findTypes(null, this.hierarchyBuilder.hierarchy.scope);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String elementName;
            HashSet<IType> set;
            IType type = iTypeArray[n2];
            String[] superTypes = type.getSuperClasses();
            if (superTypes != null) {
                int i = 0;
                while (i < superTypes.length) {
                    String s = superTypes[i];
                    LinkedList<String> extenders = (LinkedList<String>)superTypeToExtender.get(s);
                    if (extenders == null) {
                        extenders = new LinkedList<String>();
                        superTypeToExtender.put(s, extenders);
                    }
                    extenders.add(type.getTypeQualifiedName(delimiter));
                    ++i;
                }
            }
            if ((set = (HashSet<IType>)tmpCache.get(elementName = type.getTypeQualifiedName(delimiter))) == null) {
                set = new HashSet<IType>();
                tmpCache.put(elementName, set);
            }
            set.add(type);
            ++n2;
        }
        HashMap<String, IType[]> cache = new HashMap<String, IType[]>();
        for (String typeName : tmpCache.keySet()) {
            Set typeElements = (Set)tmpCache.get(typeName);
            cache.put(typeName, typeElements.toArray(new IType[typeElements.size()]));
        }
        IFileHierarchyResolver fileHierarchyResolver = HierarchyResolver.createFileHierarchyResolver(focusType);
        IFileHierarchyInfo hierarchyInfo = null;
        if (fileHierarchyResolver != null) {
            hierarchyInfo = fileHierarchyResolver.resolveDown(focusType.getSourceModule(), this.hierarchyBuilder.hierarchy.progressMonitor);
        }
        this.computeSubtypesFor(focusType, superTypeToExtender, cache, hierarchyInfo, new HashSet<IType>(), delimiter);
    }

    protected void computeSubtypesFor(IType focusType, Map<String, List<String>> superTypeToExtender, Map<String, IType[]> subTypesCache, IFileHierarchyInfo hierarchyInfo, Set<IType> processedTypes, String delimiter) throws CoreException {
        List<String> extenders = superTypeToExtender.get(focusType.getTypeQualifiedName(delimiter));
        if (extenders != null) {
            IType subType;
            IType[] subTypes = this.searchTypes(extenders.toArray(new String[extenders.size()]), subTypesCache, hierarchyInfo);
            int i = 0;
            while (i < subTypes.length) {
                subType = subTypes[i];
                this.hierarchyBuilder.hierarchy.addSubtype(focusType, subType);
                ++i;
            }
            i = 0;
            while (i < subTypes.length) {
                subType = subTypes[i];
                if (processedTypes.add(subType)) {
                    this.computeSubtypesFor(subType, superTypeToExtender, subTypesCache, hierarchyInfo, processedTypes, delimiter);
                }
                ++i;
            }
        }
    }

    protected void computeSupertypes(IType focusType) throws CoreException {
        IFileHierarchyResolver fileHierarchyResolver = HierarchyResolver.createFileHierarchyResolver(focusType);
        IFileHierarchyInfo hierarchyInfo = null;
        if (fileHierarchyResolver != null) {
            hierarchyInfo = fileHierarchyResolver.resolveUp(focusType.getSourceModule(), this.hierarchyBuilder.hierarchy.progressMonitor);
        }
        this.computeSupertypesFor(focusType, new HashMap<String, IType[]>(), hierarchyInfo, new HashSet<IType>());
    }

    protected void computeSupertypesFor(IType focusType, Map<String, IType[]> superTypesCache, IFileHierarchyInfo hierarchyInfo, Set<IType> processedTypes) throws CoreException {
        processedTypes.add(focusType);
        String[] superClasses = focusType.getSuperClasses();
        if (superClasses != null && superClasses.length > 0) {
            IType superclass;
            IType[] searchTypes = this.searchTypes(superClasses, superTypesCache, hierarchyInfo);
            int i = 0;
            while (i < searchTypes.length) {
                superclass = searchTypes[i];
                this.hierarchyBuilder.hierarchy.cacheSuperclass(focusType, superclass);
                ++i;
            }
            i = 0;
            while (i < searchTypes.length) {
                superclass = searchTypes[i];
                if (!processedTypes.contains(superclass)) {
                    this.computeSupertypesFor(superclass, superTypesCache, hierarchyInfo, processedTypes);
                }
                ++i;
            }
        } else if (!this.hierarchyBuilder.hierarchy.contains(focusType)) {
            this.hierarchyBuilder.hierarchy.addRootClass(focusType);
        }
    }

    protected IType[] searchTypes(String[] typeNames, Map<String, IType[]> cache, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        LinkedList<IType> result = new LinkedList<IType>();
        int i = 0;
        while (i < typeNames.length) {
            String typeName = typeNames[i];
            result.addAll(Arrays.asList(this.searchTypes(typeName, cache, hierarchyInfo)));
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    protected IType[] searchTypes(String type, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        return this.searchTypes(type, null, hierarchyInfo);
    }

    protected IType[] searchTypes(String typeName, Map<String, IType[]> cache, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        IType[] types;
        if (cache != null && cache.containsKey(typeName)) {
            return cache.get(typeName);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        LinkedList<IType> filteredTypes = new LinkedList<IType>();
        IType[] iTypeArray = types = this.findTypes(typeName, this.hierarchyBuilder.hierarchy.scope);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            String delimiter = this.getDelimiterReplacementString(type);
            String qualifiedName = type.getTypeQualifiedName(delimiter);
            if (typeName.equalsIgnoreCase(qualifiedName)) {
                if (hierarchyInfo != null && !hierarchyInfo.exists(type.getSourceModule())) {
                    filteredTypes.add(type);
                } else {
                    result.add(type);
                }
            }
            ++n2;
        }
        if (result.isEmpty()) {
            result.addAll(filteredTypes);
        }
        types = result.toArray(new IType[result.size()]);
        if (cache != null) {
            cache.put(typeName, types);
        }
        return types;
    }

    public void resolve(Openable[] openables, HashSet<String> localTypes) {
        block2: {
            try {
                this.resolve(true);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private static IFileHierarchyResolver createFileHierarchyResolver(IType type) throws CoreException {
        IFileHierarchyResolver fileHierarchyResolver = null;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        if (toolkit != null) {
            fileHierarchyResolver = DLTKLanguageManager.getFileHierarchyResolver(toolkit.getNatureId());
        }
        return fileHierarchyResolver;
    }

    private static ISearchPatternProcessor getSearchPatternProcessor(IType type) {
        return DLTKLanguageManager.getSearchPatternProcessor(DLTKLanguageManager.getLanguageToolkit(type));
    }

    protected String getDelimiterReplacementString(IType type) {
        ISearchPatternProcessor searchPatternProcessor = HierarchyResolver.getSearchPatternProcessor(type);
        if (searchPatternProcessor != null) {
            return searchPatternProcessor.getDelimiterReplacementString();
        }
        return "::";
    }
}

