/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BackgroundPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BlockPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BorderPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BoxPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.CommentsPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FontPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatStringPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.GeneralPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.HighlightsPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.MapPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PageBreakPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SizePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceNode;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceContentProvider;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;

public class StyleBuilder
extends PreferenceDialog {
    protected Logger logger = Logger.getLogger(StyleBuilder.class.getName());
    public static final String DLG_TITLE_NEW = Messages.getString((String)"SytleBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"SytleBuilder.DialogTitle.Edit");
    protected String title;
    private RGB titleAreaRGB;
    Color titleAreaColor;
    private Label titleLabel;
    private Label titleImageLabel;
    private Image titleImage;
    private Image titleAreaImage;
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private Label messageImageLabel;
    private Text messageLabel;
    private int messageLabelHeight;
    private Label leftFillerLabel;
    private Label bottomFillerLabel;
    private String errorMessage;
    private boolean showingError = false;
    private String message = "";
    private Image messageImage;
    private static final int H_GAP_IMAGE = 5;
    private boolean titleImageLargest = true;
    private TreeViewer viewer;
    private Composite dialogTitleArea;
    private TreeColumn[] columns;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        if (reg.get(DLG_IMG_TITLE_BANNER) == null) {
            reg.put(DLG_IMG_TITLE_BANNER, ImageDescriptor.createFromFile(TitleAreaDialog.class, (String)"images/title_banner.gif"));
        }
    }

    public StyleBuilder(Shell parentShell, ReportElementHandle handle, String title) {
        this(parentShell, handle, null, title);
    }

    public StyleBuilder(Shell parentShell, ReportElementHandle handle, AbstractThemeHandle theme, String title) {
        super(parentShell, StyleBuilder.createPreferenceManager(handle, theme));
        this.setHelpAvailable(false);
        IPreferenceNode[] nodes = this.getPreferenceManager().getRootSubNodes();
        int i = 0;
        while (i < nodes.length) {
            ((BaseStylePreferencePage)nodes[i].getPage()).setBuilder(this);
            ++i;
        }
        this.title = title;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        final Tree tree = new Tree(parent, 99076);
        tree.setHeaderVisible(false);
        this.columns = new TreeColumn[2];
        this.columns[0] = new TreeColumn(tree, 16384);
        this.columns[0].setWidth(0);
        this.columns[1] = new TreeColumn(tree, 16384);
        this.columns[1].setWidth(this.getLastRightWidth());
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TreeItem[] items = StyleBuilder.this.viewer.getTree().getItems();
                if (items != null) {
                    String[] itemContents = new String[items.length];
                    int i = 0;
                    while (i < items.length) {
                        itemContents[i] = items[i].getText(1);
                        ++i;
                    }
                    int maxString = UIUtil.getMaxStringWidth(itemContents, (Control)tree);
                    StyleBuilder.this.columns[1].setWidth((maxString += 32) > StyleBuilder.this.getLastRightWidth() ? maxString : StyleBuilder.this.getLastRightWidth());
                }
            }
        });
        this.viewer = new TreeViewer(tree);
        this.addListeners(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new PreferenceTreeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        return this.viewer;
    }

    public void refreshPagesStatus() {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public int open() {
        this.setSelectedNode("General");
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    private static PreferenceManager createPreferenceManager(ReportElementHandle handle, AbstractThemeHandle theme) {
        PreferenceManager preferenceManager = new PreferenceManager('/');
        ArrayList<StylePreferenceNode> pageContributions = new ArrayList<StylePreferenceNode>();
        pageContributions.add(new StylePreferenceNode("General", (IPreferencePage)new GeneralPreferencePage(handle, theme)));
        pageContributions.add(new StylePreferenceNode("Font", (IPreferencePage)new FontPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Size", (IPreferencePage)new SizePreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Background", (IPreferencePage)new BackgroundPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Block", (IPreferencePage)new BlockPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Box", (IPreferencePage)new BoxPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Border", (IPreferencePage)new BorderPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Number Format", (IPreferencePage)new FormatNumberPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("DateTime Format", (IPreferencePage)new FormatDateTimePreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("String Format", (IPreferencePage)new FormatStringPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("PageBreak", (IPreferencePage)new PageBreakPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Map", (IPreferencePage)new MapPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Highlights", (IPreferencePage)new HighlightsPreferencePage(handle)));
        pageContributions.add(new StylePreferenceNode("Comments", (IPreferencePage)new CommentsPreferencePage(handle)));
        for (IPreferenceNode iPreferenceNode : pageContributions) {
            preferenceManager.addToRoot(iPreferenceNode);
        }
        return preferenceManager;
    }

    private void saveAll(final boolean closeDialog) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){
            private boolean errorOccurred;
            private boolean invalid;

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public void handleException(Throwable e) {
                this.errorOccurred = true;
                if (Platform.isRunning()) {
                    String bundle = "org.eclipse.core.runtime";
                    Platform.getLog((Bundle)Platform.getBundle((String)bundle)).log((IStatus)new Status(4, bundle, 0, e.toString(), e));
                } else {
                    StyleBuilder.this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
                StyleBuilder.this.setSelectedNodePreference(null);
                String message = "";
                MessageDialog.openError((Shell)StyleBuilder.this.getShell(), (String)"", (String)message);
            }
        });
    }

    protected void okPressed() {
        this.saveAll(true);
    }

    protected Control createDialogArea(Composite parent) {
        this.createDialogTitleArea(parent);
        this.setTitleTitle(Messages.getString((String)"StyleBuilder.Title"));
        this.updateMessage("");
        return super.createDialogArea(parent);
    }

    private void createDialogTitleArea(Composite parent) {
        Color foreground;
        Color background;
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        FormLayout layout = new FormLayout();
        contents.setLayout((Layout)layout);
        this.dialogTitleArea = new Composite(contents, 0);
        this.initializeDialogUnits((Control)this.dialogTitleArea);
        FormData titleAreaData = new FormData();
        titleAreaData.top = new FormAttachment(0, 0);
        titleAreaData.left = new FormAttachment(0, 0);
        titleAreaData.right = new FormAttachment(100, 0);
        this.dialogTitleArea.setLayoutData((Object)titleAreaData);
        layout = new FormLayout();
        this.dialogTitleArea.setLayout((Layout)layout);
        this.dialogTitleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StyleBuilder.this.titleAreaColor != null) {
                    StyleBuilder.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = this.dialogTitleArea.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        this.dialogTitleArea.setBackground(background);
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.titleImageLabel = new Label(this.dialogTitleArea, 0x1000000);
        this.titleImageLabel.setBackground(background);
        if (this.titleAreaImage == null) {
            this.titleImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_BANNER));
        } else {
            this.titleImageLabel.setImage(this.titleAreaImage);
        }
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 0);
        imageData.right = new FormAttachment(100, 0);
        this.titleImageLabel.setLayoutData((Object)imageData);
        this.titleLabel = new Label(this.dialogTitleArea, 16384);
        JFaceColors.setColors((Control)this.titleLabel, (Color)foreground, (Color)background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this.titleImageLabel);
        titleData.left = new FormAttachment(0, horizontalSpacing);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label(this.dialogTitleArea, 0x1000000);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Text(this.dialogTitleArea, 72);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(this.dialogTitleArea, 0x1000000);
        this.leftFillerLabel.setBackground(background);
        this.bottomFillerLabel = new Label(this.dialogTitleArea, 0x1000000);
        this.bottomFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
    }

    private void determineTitleImageLargest() {
        int titleY = this.titleImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this.messageLabelHeight;
        this.titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageImageData = new FormData();
        messageImageData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageImageData.left = new FormAttachment(0, 5);
        this.messageImageLabel.setLayoutData((Object)messageImageData);
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        messageLabelData.height = this.messageLabelHeight;
        if (this.titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData fillerData = new FormData();
        fillerData.left = new FormAttachment(0, horizontalSpacing);
        fillerData.top = new FormAttachment((Control)this.messageImageLabel, 0);
        fillerData.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.bottomFillerLabel.setLayoutData((Object)fillerData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
        data.right = new FormAttachment((Control)this.messageImageLabel, 0);
        this.leftFillerLabel.setLayoutData((Object)data);
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
        } else {
            String displayedErrorMessage = " " + this.errorMessage;
            this.updateMessage(displayedErrorMessage);
            if (!this.showingError) {
                this.showingError = true;
                this.messageImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR));
                this.setImageLabelVisible(true);
            }
        }
        this.layoutForNewMessage();
    }

    private void setImageLabelVisible(boolean visible) {
        this.messageImageLabel.setVisible(visible);
        this.bottomFillerLabel.setVisible(visible);
        this.leftFillerLabel.setVisible(visible);
    }

    private void layoutForNewMessage() {
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        if (this.errorMessage == null && this.messageImage == null) {
            this.setImageLabelVisible(false);
            this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        } else {
            this.messageImageLabel.setVisible(true);
            this.bottomFillerLabel.setVisible(true);
            this.leftFillerLabel.setVisible(true);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
            this.messageImageLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0, 131072);
            this.bottomFillerLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0);
            this.leftFillerLabel.setLayoutData((Object)data);
            FormData messageLabelData = new FormData();
            messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
            messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
            messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, 0);
            messageLabelData.height = this.messageLabelHeight;
            if (this.titleImageLargest) {
                messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
            }
            this.messageLabel.setLayoutData((Object)messageLabelData);
        }
        if (this.dialogArea != null) {
            this.dialogTitleArea.getParent().layout(true);
            this.dialogTitleArea.layout(true);
        }
    }

    public void setTitleMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR);
                }
            }
        }
        this.showTitleMessage(newMessage, newImage);
    }

    private void showTitleMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        if (this.message == null) {
            this.message = "";
        }
        String shownMessage = newImage == null ? this.message : " " + this.message;
        this.messageImage = newImage;
        if (!this.showingError) {
            this.updateMessage(shownMessage);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
        }
        this.layoutForNewMessage();
    }

    private void updateMessage(String newMessage) {
        if (newMessage != null && newMessage.length() > 0) {
            this.messageLabel.setText(newMessage);
        } else if (DLG_TITLE_EDIT.equals(this.title)) {
            this.setTitleMessage(Messages.getString((String)"StyleBuilder.Edit.Info"));
        } else if (DLG_TITLE_NEW.equals(this.title)) {
            this.setTitleMessage(Messages.getString((String)"StyleBuilder.New.Info"));
        }
    }

    public void setTitleMessage(String message) {
        if (this.messageLabel != null) {
            this.messageLabel.setText(message);
            this.layoutForNewMessage();
        }
    }

    public void setTitleTitle(String title) {
        if (this.titleLabel != null) {
            this.titleLabel.setText(title);
            this.layoutForNewMessage();
        }
    }

    public boolean isTitleImageLargest() {
        return this.titleImageLargest;
    }

    public void setTitleImageLargest(boolean titleImageLargest) {
        this.titleImageLargest = titleImageLargest;
    }

    public Image getTitleImage() {
        return this.titleImage;
    }

    public void setTitleImage(Image titleImage) {
        this.titleImage = titleImage;
    }

    static /* synthetic */ void access$3(StyleBuilder styleBuilder) {
        styleBuilder.handleSave();
    }

    private static class PreferenceTreeLabelProvider
    implements ITableLabelProvider {
        private PreferenceTreeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ((IPreferenceNode)element).getLabelImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ((IPreferenceNode)element).getLabelText();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

