/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Objects;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * @author Abel Hegedus
 */
@FinalFieldsConstructor
@SuppressWarnings("all")
public class QueryResultTreeMatcher implements IFilteredMatcherContent {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final QueryResultTreeInput parent;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final ViatraQueryMatcher matcher;
  
  @Accessors(AccessorType.PROTECTED_SETTER)
  private IPatternMatch filterMatch;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private QueryEvaluationHint hint;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private IQuerySpecificationRegistryEntry entry;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private RuleSpecification ruleSpec;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private Exception exception;
  
  @Override
  public IPatternMatch getFilterMatch() {
    boolean _equals = Objects.equal(this.filterMatch, null);
    if (_equals) {
      IPatternMatch _newEmptyMatch = this.matcher.newEmptyMatch();
      this.filterMatch = _newEmptyMatch;
    }
    return this.filterMatch;
  }
  
  public void resetFilter() {
    IPatternMatch _newEmptyMatch = this.matcher.newEmptyMatch();
    this.filterMatch = _newEmptyMatch;
    this.filterUpdated(this.filterMatch);
  }
  
  public void filterUpdated(final IPatternMatch filterMatch) {
    if ((filterMatch != this.filterMatch)) {
      this.filterMatch = filterMatch;
    }
    this.parent.matcherFilterUpdated(this);
  }
  
  public boolean isFiltered() {
    IPatternMatch _filterMatch = this.getFilterMatch();
    Object[] _array = _filterMatch.toArray();
    final Function1<Object, Boolean> _function = new Function1<Object, Boolean>() {
      @Override
      public Boolean apply(final Object it) {
        return Boolean.valueOf((!Objects.equal(it, null)));
      }
    };
    return IterableExtensions.<Object>exists(((Iterable<Object>)Conversions.doWrapArray(_array)), _function);
  }
  
  public QueryResultTreeMatcher remove() {
    return this.parent.removeMatcher(this);
  }
  
  @Pure
  public QueryResultTreeInput getParent() {
    return this.parent;
  }
  
  @Pure
  public ViatraQueryMatcher getMatcher() {
    return this.matcher;
  }
  
  protected void setFilterMatch(final IPatternMatch filterMatch) {
    this.filterMatch = filterMatch;
  }
  
  @Pure
  public QueryEvaluationHint getHint() {
    return this.hint;
  }
  
  protected void setHint(final QueryEvaluationHint hint) {
    this.hint = hint;
  }
  
  @Pure
  public IQuerySpecificationRegistryEntry getEntry() {
    return this.entry;
  }
  
  protected void setEntry(final IQuerySpecificationRegistryEntry entry) {
    this.entry = entry;
  }
  
  @Pure
  public RuleSpecification getRuleSpec() {
    return this.ruleSpec;
  }
  
  protected void setRuleSpec(final RuleSpecification ruleSpec) {
    this.ruleSpec = ruleSpec;
  }
  
  @Pure
  public Exception getException() {
    return this.exception;
  }
  
  protected void setException(final Exception exception) {
    this.exception = exception;
  }
  
  public QueryResultTreeMatcher(final QueryResultTreeInput parent, final ViatraQueryMatcher matcher) {
    super();
    this.parent = parent;
    this.matcher = matcher;
  }
}
