/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree.SegmentHistoryTree;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;

public class HistoryTreeSegmentStore<E extends ISegment>
implements ISegmentStore<E> {
    private static final int PROVIDER_VERSION = 1;
    private static final int MAX_CHILDREN = 50;
    private static final int BLOCK_SIZE = 65536;
    private final SegmentHistoryTree<E> fSht;
    private volatile boolean fFinishedBuilding = false;

    public HistoryTreeSegmentStore(Path newStateFile, IHTIntervalReader<E> factory) throws IOException {
        this.fSht = this.createHistoryTree(newStateFile, factory);
    }

    private SegmentHistoryTree<E> createHistoryTree(Path treeFile, IHTIntervalReader<@NonNull E> intervalReader) throws IOException {
        try {
            if (Files.exists(treeFile, new LinkOption[0])) {
                return new SegmentHistoryTree<E>((File)NonNullUtils.checkNotNull((Object)treeFile.toFile()), 1, intervalReader);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SegmentHistoryTree<E>((File)NonNullUtils.checkNotNull((Object)treeFile.toFile()), 65536, 50, 1, 0L, intervalReader);
    }

    public SegmentHistoryTree<E> getSHT() {
        return this.fSht;
    }

    public long getStartTime() {
        return this.getSHT().getTreeStart();
    }

    public long getEndTime() {
        return this.getSHT().getTreeEnd();
    }

    public void finishedBuilding(long endTime) {
        this.getSHT().closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    @Override
    public void close(boolean deleteFiles) {
        if (deleteFiles) {
            this.removeFiles();
        } else {
            this.finishedBuilding(this.getEndTime());
        }
    }

    public void removeFiles() {
        this.getSHT().deleteFile();
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            this.getSHT().closeFile();
        } else {
            this.getSHT().deleteFile();
        }
    }

    public long getFileSize() {
        return this.getSHT().getFileSize();
    }

    @Override
    public boolean add(E interval) {
        this.getSHT().insert((IHTInterval)interval);
        return true;
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        c.forEach(interval -> {
            boolean bl = this.add((E)interval);
        });
        return true;
    }

    @Override
    public int size() {
        return this.getSHT().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getSHT().isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (o instanceof ISegment) {
            ISegment seg = (ISegment)o;
            if (seg.getStart() < this.getStartTime() || seg.getEnd() > this.getEndTime()) {
                return false;
            }
            Iterable<@NonNull E> iterable = this.getIntersectingElements(seg.getStart());
            return Iterables.contains(iterable, (Object)seg);
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        ISegment seg;
        if (c == null) {
            return false;
        }
        long minEnd = Long.MAX_VALUE;
        long maxStart = Long.MIN_VALUE;
        for (Object o : c) {
            if (o instanceof ISegment) {
                seg = (ISegment)o;
                if (seg.getStart() < this.getStartTime() || seg.getEnd() > this.getEndTime()) {
                    return false;
                }
                minEnd = Math.min(minEnd, seg.getEnd());
                maxStart = Math.max(maxStart, seg.getStart());
                continue;
            }
            return false;
        }
        if (minEnd > maxStart) {
            minEnd = maxStart;
        }
        Iterator<@NonNull E> iterator = this.getIntersectingElements(minEnd, maxStart).iterator();
        int unFound = c.size();
        while (iterator.hasNext() && unFound > 0) {
            seg = (ISegment)iterator.next();
            for (Object o : c) {
                if (!Objects.equals(o, seg)) continue;
                --unFound;
            }
        }
        return unFound == 0;
    }

    @Override
    public @Nullable Iterator<E> iterator() {
        return this.getSHT().iterator();
    }

    @Override
    public Object @NonNull [] toArray() {
        throw new UnsupportedOperationException("This segment store can potentially cause OutOfMemoryExceptions");
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        throw new UnsupportedOperationException("This segment store can potentially cause OutOfMemoryExceptions");
    }

    @Override
    public void clear() {
        try {
            this.getSHT().cleanFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("HT segment store: couldn't clear the HT file: " + e.getMessage());
        }
    }

    @Override
    public @NonNull Iterable<E> getIntersectingElements(long start, long end) {
        return this.getSHT().getIntersectingElements(start, end);
    }

    @Override
    public Iterable<E> getIntersectingElements(long start, long end, @Nullable Comparator<ISegment> order) {
        if (order == null) {
            return this.getSHT().getIntersectingElements(start, end);
        }
        return this.getSHT().getIntersectingElements(start, end, order);
    }
}

