/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.datastore.core.condition;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;

public class SingletonTimeRangeCondition
implements TimeRangeCondition {
    private final long fValue;

    public SingletonTimeRangeCondition(long ts) {
        this.fValue = ts;
    }

    @Override
    public long min() {
        return this.fValue;
    }

    @Override
    public long max() {
        return this.fValue;
    }

    @Override
    public boolean test(long element) {
        return element == this.fValue;
    }

    @Override
    public boolean intersects(long low, long high) {
        return low <= this.fValue && high >= this.fValue;
    }

    @Override
    public @Nullable TimeRangeCondition subCondition(long from, long to) {
        if (this.intersects(from, to)) {
            return this;
        }
        return null;
    }
}

