/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;

public class AggregatedCalledFunctionStatistics {
    private final IStatistics<ICalledFunction> fDurations = new Statistics<ICalledFunction>(f -> f.getLength());
    private final IStatistics<ICalledFunction> fSelfTimes = new Statistics<ICalledFunction>(f -> f.getSelfTime());

    public void update(ICalledFunction function) {
        this.fDurations.update(function);
        this.fSelfTimes.update(function);
    }

    public void merge(AggregatedCalledFunctionStatistics statisticsNode) {
        this.fDurations.merge(statisticsNode.fDurations);
        this.fSelfTimes.merge(statisticsNode.fSelfTimes);
    }

    public IStatistics<ICalledFunction> getDurationStatistics() {
        return this.fDurations;
    }

    public IStatistics<ICalledFunction> getSelfTimeStatistics() {
        return this.fSelfTimes;
    }

    public String toString() {
        return "Aggregated function statistics: Durations: " + this.fDurations + ", Self times " + this.fSelfTimes;
    }
}

