/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageTreeViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class KernelMemoryUsageView
extends TmfChartView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview";
    public static final @NonNull String KERNEL_MEMORY = "org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview.KERNEL_MEMORY";
    private KernelMemoryUsageTreeViewer fTreeViewerReference = null;

    public KernelMemoryUsageView() {
        super(Messages.MemoryUsageView_title);
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        return new KernelMemoryUsageViewer(parent);
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        KernelMemoryUsageTreeViewer fTreeViewer;
        this.fTreeViewerReference = fTreeViewer = new KernelMemoryUsageTreeViewer(parent);
        fTreeViewer.addSelectionChangeListener(new SelectionChangeListener());
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            fTreeViewer.traceSelected(signal);
            this.fTreeViewerReference.traceSelected(signal);
        }
        fTreeViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
            }
        });
        return fTreeViewer;
    }

    @VisibleForTesting
    public TmfXYChartViewer getChartViewer() {
        return super.getChartViewer();
    }

    private final class SelectionChangeListener
    implements ISelectionChangedListener {
        private SelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object structSelection;
            KernelMemoryUsageTreeViewer treeViewer = KernelMemoryUsageView.this.fTreeViewerReference;
            KernelMemoryUsageViewer chartViewer = (KernelMemoryUsageViewer)KernelMemoryUsageView.this.getChartViewer();
            if (treeViewer == null || chartViewer == null) {
                return;
            }
            ITmfTrace trace = treeViewer.getTrace();
            if (trace == null) {
                return;
            }
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (structSelection = ((IStructuredSelection)selection).getFirstElement()) instanceof KernelMemoryUsageEntry) {
                KernelMemoryUsageEntry entry = (KernelMemoryUsageEntry)((Object)structSelection);
                String tid = entry.getTid();
                if (tid == null) {
                    return;
                }
                treeViewer.setSelectedThread(tid);
                chartViewer.setSelectedThread(tid);
                TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(KernelMemoryUsageView.KERNEL_MEMORY, (Object)tid));
            }
        }
    }
}

