/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class SchedWakeupHandler
extends KernelEventHandler {
    public SchedWakeupHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        int tid = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldTid()}).getValue()).intValue();
        int prio = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldPrio()}).getValue()).intValue();
        String threadAttributeName = Attributes.buildThreadAttributeName(tid, cpu);
        if (threadAttributeName == null) {
            return;
        }
        int threadNode = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeThreads(ss), new String[]{threadAttributeName});
        int status = ss.queryOngoingState(threadNode).unboxInt();
        ITmfStateValue value = null;
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        if (status != 3 && status != 2) {
            value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
            ss.modifyAttribute(timestamp, value, threadNode);
        }
        int quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Prio"});
        value = TmfStateValue.newValueInt((int)prio);
        ss.modifyAttribute(timestamp, value, quark);
    }
}

