/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathAlgorithm;

public abstract class AbstractCriticalPathAlgorithm
implements ICriticalPathAlgorithm {
    private final TmfGraph fGraph;

    public AbstractCriticalPathAlgorithm(TmfGraph graph) {
        this.fGraph = graph;
    }

    public TmfGraph getGraph() {
        return this.fGraph;
    }

    public TmfVertex copyLink(TmfGraph criticalPath, TmfGraph graph, TmfVertex anchor, TmfVertex from, TmfVertex to, long ts, TmfEdge.EdgeType type) {
        IGraphWorker parentFrom = graph.getParentOf(from);
        IGraphWorker parentTo = graph.getParentOf(to);
        if (parentTo == null) {
            throw new NullPointerException();
        }
        TmfVertex tmp = new TmfVertex(ts);
        criticalPath.add(parentTo, tmp);
        if (parentFrom == parentTo) {
            anchor.linkHorizontal(tmp).setType(type);
        } else {
            anchor.linkVertical(tmp).setType(type);
        }
        return tmp;
    }

    public static @Nullable TmfVertex findIncoming(TmfVertex vertex, TmfVertex.EdgeDirection dir) {
        TmfVertex currentVertex = vertex;
        while (true) {
            TmfEdge incoming;
            if ((incoming = currentVertex.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE)) != null) {
                return currentVertex;
            }
            TmfEdge edge = currentVertex.getEdge(dir);
            if (edge == null || edge.getType() != TmfEdge.EdgeType.EPS) break;
            currentVertex = TmfVertex.getNeighborFromEdge(edge, dir);
        }
        return null;
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }
}

